/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;

public class NonNullArrayList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 6567438878579505932L;

    @Override
    public boolean add(E element) {
        return super.add(Preconditions.checkNotNull(element, "Element cannot be null"));
    }

    @Override
    public void add(int index, E element) {
        super.add(index, Preconditions.checkNotNull(element, "Element cannot be null"));
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        for (E next : collection) {
            Preconditions.checkNotNull(next, "Element cannot be null");
        }
        return super.addAll(collection);
    }

    @Override
    public E set(int index, E element) {
        return super.set(index, Preconditions.checkNotNull(element, "Element cannot be null"));
    }
}

