/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import javax.annotation.Nullable;

public final class TypeTokenHelper {
    public static Class<?> getGenericParam(TypeToken<?> token, int typeIndex) {
        return (Class)((ParameterizedType)token.getType()).getActualTypeArguments()[typeIndex];
    }

    public static boolean isAssignable(TypeToken<?> type, TypeToken<?> toType) {
        return TypeTokenHelper.isAssignable(type.getType(), toType.getType());
    }

    public static boolean isAssignable(Type type, Type toType) {
        return TypeTokenHelper.isAssignable(type, toType, null, 0);
    }

    private static boolean isAssignable(Type type, Type toType, @Nullable Type parent, int index) {
        if (type.equals(toType)) {
            return true;
        }
        if (toType instanceof Class) {
            return TypeTokenHelper.isAssignable(type, (Class)toType, parent, index);
        }
        if (toType instanceof ParameterizedType) {
            return TypeTokenHelper.isAssignable(type, (ParameterizedType)toType, parent, index);
        }
        if (toType instanceof TypeVariable) {
            return TypeTokenHelper.isAssignable(type, (TypeVariable)toType, parent, index);
        }
        if (toType instanceof WildcardType) {
            return TypeTokenHelper.isAssignable(type, (WildcardType)toType, parent, index);
        }
        if (toType instanceof GenericArrayType) {
            return TypeTokenHelper.isAssignable(type, (GenericArrayType)toType, parent, index);
        }
        throw new IllegalStateException("Unsupported type: " + type);
    }

    private static boolean isAssignable(Type type, Class<?> toType, @Nullable Type parent, int index) {
        if (type instanceof Class) {
            Class<?> otherEnclosing;
            Class other = (Class)type;
            Class<?> toEnclosing = toType.getEnclosingClass();
            if (!(toEnclosing == null || Modifier.isStatic(toType.getModifiers()) || (otherEnclosing = other.getEnclosingClass()) != null && TypeTokenHelper.isAssignable(otherEnclosing, toEnclosing, null, 0))) {
                return false;
            }
            return toType.isAssignableFrom(other);
        }
        if (type instanceof ParameterizedType) {
            Type otherEnclosing;
            ParameterizedType other = (ParameterizedType)type;
            Class<?> toEnclosing = toType.getEnclosingClass();
            if (!(toEnclosing == null || Modifier.isStatic(toType.getModifiers()) || (otherEnclosing = other.getOwnerType()) != null && TypeTokenHelper.isAssignable(otherEnclosing, toEnclosing, null, 0))) {
                return false;
            }
            return toType.isAssignableFrom((Class)other.getRawType());
        }
        if (type instanceof TypeVariable) {
            TypeVariable other = (TypeVariable)type;
            return TypeTokenHelper.allSupertypes(toType, other.getBounds());
        }
        if (type instanceof WildcardType) {
            WildcardType other = (WildcardType)type;
            return TypeTokenHelper.allWildcardSupertypes(toType, other.getUpperBounds(), parent, index) && TypeTokenHelper.allAssignable(toType, other.getLowerBounds());
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType other = (GenericArrayType)type;
            return toType.equals(Object.class) || toType.isArray() && TypeTokenHelper.isAssignable(other.getGenericComponentType(), toType.getComponentType(), parent, index);
        }
        throw new IllegalStateException("Unsupported type: " + type);
    }

    private static boolean isAssignable(Type type, ParameterizedType toType, @Nullable Type parent, int index) {
        if (type instanceof Class) {
            Type[] types;
            Class<?> otherEnclosing;
            Class otherRaw = (Class)type;
            Class toRaw = (Class)toType.getRawType();
            if (!toRaw.isAssignableFrom(otherRaw)) {
                return false;
            }
            Type toEnclosing = toType.getOwnerType();
            if (!(toEnclosing == null || Modifier.isStatic(toRaw.getModifiers()) || (otherEnclosing = otherRaw.getEnclosingClass()) != null && TypeTokenHelper.isAssignable(otherEnclosing, toEnclosing, null, 0))) {
                return false;
            }
            Type[] toTypes = toType.getActualTypeArguments();
            if (otherRaw.equals(toRaw)) {
                types = otherRaw.getTypeParameters();
            } else {
                ParameterizedType other = (ParameterizedType)TypeToken.of(type).getSupertype(toRaw).getType();
                types = other.getActualTypeArguments();
            }
            if (types.length != toTypes.length) {
                return false;
            }
            for (int i = 0; i < types.length; ++i) {
                if (TypeTokenHelper.isAssignable(types[i], toTypes[i], type, i)) continue;
                return false;
            }
            return true;
        }
        if (type instanceof ParameterizedType) {
            Type[] types;
            Type otherEnclosing;
            ParameterizedType other = (ParameterizedType)type;
            Class otherRaw = (Class)other.getRawType();
            Class toRaw = (Class)toType.getRawType();
            if (!toRaw.isAssignableFrom(otherRaw)) {
                return false;
            }
            Type toEnclosing = toType.getOwnerType();
            if (!(toEnclosing == null || Modifier.isStatic(toRaw.getModifiers()) || (otherEnclosing = other.getOwnerType()) != null && TypeTokenHelper.isAssignable(otherEnclosing, toEnclosing, null, 0))) {
                return false;
            }
            if (otherRaw.equals(toRaw)) {
                types = other.getActualTypeArguments();
            } else {
                other = (ParameterizedType)TypeToken.of(other).getSupertype(toRaw).getType();
                types = other.getActualTypeArguments();
            }
            Type[] toTypes = toType.getActualTypeArguments();
            if (types.length != toTypes.length) {
                return false;
            }
            for (int i = 0; i < types.length; ++i) {
                if (TypeTokenHelper.isAssignable(types[i], toTypes[i], (Type)other, i)) continue;
                return false;
            }
            return true;
        }
        if (type instanceof TypeVariable) {
            TypeVariable other = (TypeVariable)type;
            return TypeTokenHelper.allSupertypes(toType, other.getBounds());
        }
        if (type instanceof WildcardType) {
            WildcardType other = (WildcardType)type;
            return TypeTokenHelper.allWildcardSupertypes(toType, other.getUpperBounds(), parent, index) && TypeTokenHelper.allAssignable(toType, other.getLowerBounds());
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType other = (GenericArrayType)type;
            Class rawType = (Class)toType.getRawType();
            return rawType.equals(Object.class) || rawType.isArray() && TypeTokenHelper.isAssignable(other.getGenericComponentType(), rawType.getComponentType(), parent, index);
        }
        throw new IllegalStateException("Unsupported type: " + type);
    }

    private static boolean isAssignable(Type type, TypeVariable toType, @Nullable Type parent, int index) {
        return TypeTokenHelper.allAssignable(type, toType.getBounds());
    }

    private static boolean isAssignable(Type type, WildcardType toType, @Nullable Type parent, int index) {
        return TypeTokenHelper.allWildcardAssignable(type, toType.getUpperBounds(), parent, index) && TypeTokenHelper.allSupertypes(type, toType.getLowerBounds());
    }

    private static boolean isAssignable(Type type, GenericArrayType toType, @Nullable Type parent, int index) {
        if (type instanceof Class) {
            Class other = (Class)type;
            return other.isArray() && TypeTokenHelper.isAssignable(other.getComponentType(), toType.getGenericComponentType(), parent, index);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType other = (ParameterizedType)type;
            Class rawType = (Class)other.getRawType();
            return rawType.isArray() && TypeTokenHelper.isAssignable(rawType.getComponentType(), toType.getGenericComponentType(), parent, index);
        }
        if (type instanceof TypeVariable) {
            TypeVariable other = (TypeVariable)type;
            return TypeTokenHelper.allSupertypes(toType, other.getBounds());
        }
        if (type instanceof WildcardType) {
            WildcardType other = (WildcardType)type;
            return TypeTokenHelper.allWildcardSupertypes(toType, other.getUpperBounds(), parent, index) && TypeTokenHelper.allAssignable(toType, other.getLowerBounds());
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType other = (GenericArrayType)type;
            return TypeTokenHelper.isAssignable(other.getGenericComponentType(), toType.getGenericComponentType(), parent, index);
        }
        throw new IllegalStateException("Unsupported type: " + type);
    }

    private static Type[] processBounds(Type[] bounds, @Nullable Type parent, int index) {
        if (bounds.length == 0 || bounds.length == 1 && bounds[0].equals(Object.class)) {
            Class theClass = null;
            if (parent instanceof Class) {
                theClass = (Class)parent;
            } else if (parent instanceof ParameterizedType) {
                theClass = (Class)((ParameterizedType)parent).getRawType();
            }
            if (theClass != null) {
                TypeVariable<Class<T>>[] typeVariables = theClass.getTypeParameters();
                bounds = typeVariables[index].getBounds();
                for (int i = 0; i < bounds.length; ++i) {
                    if (bounds[i] instanceof TypeVariable || bounds[i] instanceof WildcardType) {
                        bounds[i] = Object.class;
                        continue;
                    }
                    if (bounds[i] instanceof ParameterizedType) {
                        bounds[i] = ((ParameterizedType)bounds[i]).getRawType();
                        continue;
                    }
                    if (!(bounds[i] instanceof GenericArrayType)) continue;
                    Type component = ((GenericArrayType)bounds[i]).getGenericComponentType();
                    Class componentClass = component instanceof Class ? (Class)component : (component instanceof ParameterizedType ? (Class)((ParameterizedType)component).getRawType() : Object.class);
                    bounds[i] = componentClass == Object.class ? Object[].class : Array.newInstance(componentClass, 0).getClass();
                }
            }
        }
        return bounds;
    }

    private static boolean allWildcardSupertypes(Type type, Type[] bounds, @Nullable Type parent, int index) {
        return TypeTokenHelper.allSupertypes(type, TypeTokenHelper.processBounds(bounds, parent, index));
    }

    private static boolean allWildcardAssignable(Type type, Type[] bounds, @Nullable Type parent, int index) {
        return TypeTokenHelper.allAssignable(type, TypeTokenHelper.processBounds(bounds, parent, index));
    }

    private static boolean allAssignable(Type type, Type[] bounds) {
        for (Type toType : bounds) {
            if (TypeTokenHelper.isAssignable(type, toType, null, 0)) continue;
            return false;
        }
        return true;
    }

    private static boolean allSupertypes(Type type, Type[] bounds) {
        for (Type toType : bounds) {
            if (TypeTokenHelper.isAssignable(toType, type, null, 0)) continue;
            return false;
        }
        return true;
    }

    private TypeTokenHelper() {
    }
}

