/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.util.gen;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Objects;
import org.spongepowered.api.util.DiscreteTransform3;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.biome.BiomeTypes;
import org.spongepowered.api.world.extent.ImmutableBiomeVolume;
import org.spongepowered.api.world.extent.MutableBiomeVolume;
import org.spongepowered.api.world.extent.StorageType;
import org.spongepowered.api.world.extent.UnmodifiableBiomeVolume;
import org.spongepowered.api.world.extent.worker.MutableBiomeVolumeWorker;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.common.util.gen.AbstractBiomeBuffer;
import org.spongepowered.common.util.gen.ByteArrayImmutableBiomeBuffer;
import org.spongepowered.common.world.extent.MutableBiomeViewDownsize;
import org.spongepowered.common.world.extent.MutableBiomeViewTransform;
import org.spongepowered.common.world.extent.UnmodifiableBiomeVolumeWrapper;
import org.spongepowered.common.world.extent.worker.SpongeMutableBiomeVolumeWorker;

public final class ByteArrayMutableBiomeBuffer
extends AbstractBiomeBuffer
implements MutableBiomeVolume {
    private boolean detached;
    private final byte[] biomes;
    private final Palette<BiomeType> palette;

    private void checkOpen() {
        Preconditions.checkState(!this.detached, "trying to use buffer after it's closed");
    }

    public ByteArrayMutableBiomeBuffer(Palette<BiomeType> palette, Vector3i start, Vector3i size) {
        this(palette, new byte[size.getX() * size.getZ()], start, size);
    }

    public ByteArrayMutableBiomeBuffer(Palette<BiomeType> palette, byte[] biomes, Vector3i start, Vector3i size) {
        super(start, size);
        this.biomes = biomes;
        this.palette = palette;
    }

    @Override
    public void setBiome(int x, int y, int z, BiomeType biome) {
        this.checkOpen();
        this.checkRange(x, y, z);
        this.biomes[this.getIndex((int)x, (int)z)] = (byte)this.palette.getOrAssign(biome);
    }

    @Override
    public BiomeType getBiome(int x, int y, int z) {
        this.checkOpen();
        this.checkRange(x, y, z);
        byte biomeId = this.biomes[this.getIndex(x, z)];
        return (BiomeType)((Object)this.palette.get((BiomeType)(biomeId & 0xFF)).orElse((Integer)((Object)BiomeTypes.OCEAN)));
    }

    public byte[] detach() {
        this.checkOpen();
        this.detached = true;
        return this.biomes;
    }

    public boolean isDetached() {
        return this.detached;
    }

    public void reuse(Vector3i start) {
        Preconditions.checkState(this.detached, "Cannot reuse while still in use");
        this.start = Preconditions.checkNotNull(start, "start");
        this.end = this.start.add(this.size).sub(Vector3i.ONE);
        Arrays.fill(this.biomes, (byte)0);
        this.detached = false;
    }

    @Override
    public MutableBiomeVolume getBiomeView(Vector3i newMin, Vector3i newMax) {
        this.checkRange(newMin.getX(), newMin.getY(), newMin.getZ());
        this.checkRange(newMax.getX(), newMax.getY(), newMax.getZ());
        return new MutableBiomeViewDownsize(this, newMin, newMax);
    }

    @Override
    public MutableBiomeVolume getBiomeView(DiscreteTransform3 transform) {
        return new MutableBiomeViewTransform(this, transform);
    }

    @Override
    public MutableBiomeVolumeWorker<? extends MutableBiomeVolume> getBiomeWorker() {
        return new SpongeMutableBiomeVolumeWorker<ByteArrayMutableBiomeBuffer>(this);
    }

    @Override
    public UnmodifiableBiomeVolume getUnmodifiableBiomeView() {
        return new UnmodifiableBiomeVolumeWrapper(this);
    }

    @Override
    public MutableBiomeVolume getBiomeCopy(StorageType type) {
        this.checkOpen();
        switch (type) {
            case STANDARD: {
                return new ByteArrayMutableBiomeBuffer(this.palette, (byte[])this.biomes.clone(), this.start, this.size);
            }
        }
        throw new UnsupportedOperationException(type.name());
    }

    @Override
    public ImmutableBiomeVolume getImmutableBiomeCopy() {
        this.checkOpen();
        return new ByteArrayImmutableBiomeBuffer(this.palette, this.biomes, this.start, this.size);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ByteArrayMutableBiomeBuffer that = (ByteArrayMutableBiomeBuffer)o;
        return this.detached == that.detached && Arrays.equals(this.biomes, that.biomes) && this.palette.equals(that.palette);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.detached, this.palette);
        result = 31 * result + Arrays.hashCode(this.biomes);
        return result;
    }
}

