/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.weather;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.weather.Weather;

@NonnullByDefault
public class SpongeWeather
implements Weather {
    private final String id;
    private final String name;

    public SpongeWeather(String id, String name) {
        this.id = Preconditions.checkNotNull(id);
        this.name = Preconditions.checkNotNull(name);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("name", this.name).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeWeather that = (SpongeWeather)o;
        return Objects.equal(this.id, that.id) && Objects.equal(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.name);
    }
}

