/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.base.Preconditions;
import net.minecraft.entity.Entity;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import org.spongepowered.api.entity.explosive.Explosive;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.common.bridge.world.ExplosionBridge;

public class SpongeExplosionBuilder
implements Explosion.Builder {
    private Location<org.spongepowered.api.world.World> location;
    private Explosive sourceExplosive;
    private float radius;
    private boolean canCauseFire;
    private boolean shouldBreakBlocks = true;
    private boolean shouldSmoke;
    private boolean shouldDamageEntities = true;
    private int resolution = 16;
    private float randomness = 1.0f;
    private double knockback = 1.0;

    public SpongeExplosionBuilder() {
        this.reset();
    }

    @Override
    public Explosion.Builder sourceExplosive(Explosive source) {
        this.sourceExplosive = source;
        return this;
    }

    @Override
    public Explosion.Builder radius(float radius) {
        this.radius = radius;
        return this;
    }

    @Override
    public Explosion.Builder location(Location<org.spongepowered.api.world.World> location) {
        this.location = Preconditions.checkNotNull(location, "location");
        return this;
    }

    @Override
    public Explosion.Builder canCauseFire(boolean fire) {
        this.canCauseFire = fire;
        return this;
    }

    @Override
    public Explosion.Builder shouldDamageEntities(boolean damage) {
        this.shouldDamageEntities = damage;
        return this;
    }

    @Override
    public Explosion.Builder shouldPlaySmoke(boolean smoke) {
        this.shouldSmoke = smoke;
        return this;
    }

    @Override
    public Explosion.Builder shouldBreakBlocks(boolean destroy) {
        this.shouldBreakBlocks = destroy;
        return this;
    }

    @Override
    public Explosion.Builder resolution(int resolution) {
        this.resolution = Math.max(resolution, 2);
        return this;
    }

    @Override
    public Explosion.Builder randomness(float randomness) {
        this.randomness = randomness;
        return this;
    }

    @Override
    public Explosion.Builder knockback(double knockback) {
        this.knockback = knockback;
        return this;
    }

    @Override
    public Explosion.Builder from(org.spongepowered.api.world.explosion.Explosion value) {
        this.location = value.getLocation();
        this.sourceExplosive = value.getSourceExplosive().orElse(null);
        this.radius = value.getRadius();
        this.canCauseFire = value.canCauseFire();
        this.shouldBreakBlocks = value.shouldBreakBlocks();
        this.shouldSmoke = value.shouldPlaySmoke();
        this.shouldDamageEntities = value.shouldDamageEntities();
        this.resolution = value.getResolution();
        this.randomness = value.getRandomness();
        this.knockback = value.getKnockback();
        return this;
    }

    @Override
    public SpongeExplosionBuilder reset() {
        this.location = null;
        this.sourceExplosive = null;
        this.radius = 0.0f;
        this.canCauseFire = false;
        this.shouldBreakBlocks = true;
        this.shouldSmoke = false;
        this.shouldDamageEntities = true;
        this.resolution = 16;
        this.randomness = 1.0f;
        this.knockback = 1.0;
        return this;
    }

    @Override
    public org.spongepowered.api.world.explosion.Explosion build() throws IllegalStateException {
        Preconditions.checkState(this.location != null, "Location is null!");
        org.spongepowered.api.world.World world = this.location.getExtent();
        Vector3d origin = this.location.getPosition();
        Explosion explosion = new Explosion((World)world, (Entity)this.sourceExplosive, origin.getX(), origin.getY(), origin.getZ(), this.radius, this.canCauseFire, this.shouldSmoke);
        ((ExplosionBridge)explosion).bridge$setShouldBreakBlocks(this.shouldBreakBlocks);
        ((ExplosionBridge)explosion).bridge$setShouldDamageEntities(this.shouldDamageEntities);
        ((ExplosionBridge)explosion).bridge$setResolution(this.resolution);
        ((ExplosionBridge)explosion).bridge$setRandomness(this.randomness);
        ((ExplosionBridge)explosion).bridge$setKnockback(this.knockback);
        return (org.spongepowered.api.world.explosion.Explosion)explosion;
    }
}

