/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import org.spongepowered.api.world.PortalAgent;
import org.spongepowered.api.world.PortalAgentType;
import org.spongepowered.common.bridge.world.ForgeITeleporterBridge;

public final class SpongePortalAgentType
implements PortalAgentType {
    private final String name;
    private final String id;
    private final Class<? extends ForgeITeleporterBridge> portalAgentClass;

    public SpongePortalAgentType(String id, String name, Class<? extends ForgeITeleporterBridge> portalAgentClass) {
        this.id = Preconditions.checkNotNull(id);
        this.name = Preconditions.checkNotNull(name);
        this.portalAgentClass = Preconditions.checkNotNull(portalAgentClass, "The class was null! The id was: " + id);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<? extends PortalAgent> getPortalAgentClass() {
        return this.portalAgentClass;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("name", this.name).add("class", this.portalAgentClass.getName()).toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PortalAgentType)) {
            return false;
        }
        PortalAgentType other = (PortalAgentType)obj;
        return this.id.equals(other.getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

