/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.MapMaker;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.world.DimensionType;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameType;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.MinecraftException;
import net.minecraft.world.ServerWorldEventHandler;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.storage.AnvilSaveHandler;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import org.spongepowered.api.GameState;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.world.UnloadWorldEvent;
import org.spongepowered.api.util.file.CopyFileVisitor;
import org.spongepowered.api.util.file.DeleteFileVisitor;
import org.spongepowered.api.util.file.ForwardingFileVisitor;
import org.spongepowered.api.world.DimensionTypes;
import org.spongepowered.api.world.SerializationBehaviors;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.WorldArchetype;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.server.MinecraftServerBridge;
import org.spongepowered.common.bridge.server.integrated.IntegratedServerBridge;
import org.spongepowered.common.bridge.world.DimensionTypeBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.WorldInfoBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge_AsyncLighting;
import org.spongepowered.common.bridge.world.WorldSettingsBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkProviderServerBridge;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.type.GeneralConfigBase;
import org.spongepowered.common.config.type.GlobalConfig;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;
import org.spongepowered.common.mixin.core.server.MinecraftServerAccessor;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.SpongeHooks;
import org.spongepowered.common.world.WorldMigrator;

public final class WorldManager {
    private static final boolean MIGRATE_WORLDS = Boolean.parseBoolean(System.getProperty("sponge.world.migrate_old", "true"));
    private static final DirectoryStream.Filter<Path> LEVEL_AND_SPONGE = entry -> Files.isDirectory(entry, new LinkOption[0]) && Files.exists(entry.resolve("level.dat"), new LinkOption[0]) && Files.exists(entry.resolve("level_sponge.dat"), new LinkOption[0]);
    private static final Int2ReferenceMap<DimensionType> dimensionTypeByTypeId = new Int2ReferenceOpenHashMap<DimensionType>(3);
    private static final Int2ReferenceMap<DimensionType> dimensionTypeByDimensionId = new Int2ReferenceOpenHashMap<DimensionType>(3);
    private static final Int2ObjectMap<Path> dimensionPathByDimensionId = new Int2ObjectOpenHashMap<Path>(3);
    private static final Int2ObjectOpenHashMap<WorldServer> worldByDimensionId = new Int2ObjectOpenHashMap(3);
    private static final Map<String, WorldProperties> worldPropertiesByFolderName = new HashMap<String, WorldProperties>(3);
    private static final Map<UUID, WorldProperties> worldPropertiesByWorldUuid = new HashMap<UUID, WorldProperties>(3);
    private static final Int2ObjectMap<String> worldFolderByDimensionId = new Int2ObjectOpenHashMap<String>();
    private static final BiMap<String, UUID> worldUuidByFolderName = HashBiMap.create(3);
    private static final IntSet usedDimensionIds = new IntOpenHashSet();
    private static final Map<WorldServer, WorldServer> weakWorldByWorld = new MapMaker().weakKeys().weakValues().concurrencyLevel(1).makeMap();
    private static final Queue<WorldServer> unloadQueue = new ArrayDeque<WorldServer>();
    private static final Comparator<WorldServer> WORLD_SERVER_COMPARATOR = (world1, world2) -> {
        int world1DimId = ((WorldServerBridge)world1).bridge$getDimensionId();
        if (world2 == null) {
            return world1DimId;
        }
        int world2DimId = ((WorldServerBridge)world2).bridge$getDimensionId();
        return world1DimId - world2DimId;
    };
    private static boolean isVanillaRegistered = false;
    private static int lastUsedDimensionId = 0;

    public static void registerVanillaTypesAndDimensions() {
        if (!isVanillaRegistered) {
            WorldManager.registerDimensionType(0, DimensionType.OVERWORLD);
            WorldManager.registerDimensionType(-1, DimensionType.NETHER);
            WorldManager.registerDimensionType(1, DimensionType.THE_END);
            WorldManager.registerDimension(0, DimensionType.OVERWORLD);
            WorldManager.registerDimension(-1, DimensionType.NETHER);
            WorldManager.registerDimension(1, DimensionType.THE_END);
        }
        isVanillaRegistered = true;
    }

    public static void registerDimensionType(DimensionType type) {
        Preconditions.checkNotNull(type);
        OptionalInt optNextDimensionTypeId = WorldManager.getNextFreeDimensionTypeId();
        optNextDimensionTypeId.ifPresent(integer -> WorldManager.registerDimensionType(integer, type));
    }

    public static void registerDimensionType(int dimensionTypeId, DimensionType type) {
        Preconditions.checkNotNull(type);
        dimensionTypeByTypeId.putIfAbsent(dimensionTypeId, type);
    }

    private static OptionalInt getNextFreeDimensionTypeId() {
        Integer highestDimensionTypeId = null;
        IntIterator iterator = dimensionTypeByTypeId.keySet().iterator();
        while (iterator.hasNext()) {
            int dimensionTypeId = iterator.nextInt();
            if (highestDimensionTypeId != null && highestDimensionTypeId >= dimensionTypeId) continue;
            highestDimensionTypeId = dimensionTypeId;
        }
        if (highestDimensionTypeId != null && highestDimensionTypeId < 127) {
            highestDimensionTypeId = highestDimensionTypeId + 1;
            return OptionalInt.of(highestDimensionTypeId);
        }
        return OptionalInt.empty();
    }

    public static Integer getNextFreeDimensionId() {
        int next = lastUsedDimensionId;
        while (usedDimensionIds.contains(next) || !WorldManager.checkAvailable(next)) {
            ++next;
        }
        lastUsedDimensionId = next;
        return lastUsedDimensionId;
    }

    private static boolean checkAvailable(int dimensionId) {
        if (worldByDimensionId.containsKey(dimensionId)) {
            usedDimensionIds.add(dimensionId);
            return false;
        }
        return true;
    }

    public static void registerDimension(int dimensionId, DimensionType type) {
        Preconditions.checkNotNull(type);
        if (!dimensionTypeByTypeId.containsValue(type)) {
            return;
        }
        DimensionType previous = dimensionTypeByDimensionId.putIfAbsent(dimensionId, type);
        if (previous != null) {
            return;
        }
        if (dimensionId >= 0) {
            usedDimensionIds.add(dimensionId);
        }
    }

    public static void unregisterDimension(int dimensionId) {
        DimensionType previous = (DimensionType)dimensionTypeByDimensionId.remove(dimensionId);
        if (previous == null) {
            throw new IllegalArgumentException("Failed to unregister dimension [" + dimensionId + "] as it is not registered!");
        }
    }

    private static void registerVanillaDimensionPaths(Path savePath) {
        WorldManager.registerDimensionPath(0, savePath);
        WorldManager.registerDimensionPath(-1, savePath.resolve("DIM-1"));
        WorldManager.registerDimensionPath(1, savePath.resolve("DIM1"));
    }

    public static void registerDimensionPath(int dimensionId, Path dimensionDataRoot) {
        Preconditions.checkNotNull(dimensionDataRoot);
        dimensionPathByDimensionId.put(dimensionId, dimensionDataRoot);
    }

    public static Path getDimensionPath(int dimensionId) {
        return (Path)dimensionPathByDimensionId.get(dimensionId);
    }

    public static Optional<DimensionType> getDimensionType(int dimensionId) {
        return Optional.ofNullable(dimensionTypeByDimensionId.get(dimensionId));
    }

    public static Optional<DimensionType> getDimensionTypeByTypeId(int dimensionTypeId) {
        return Optional.ofNullable(dimensionTypeByTypeId.get(dimensionTypeId));
    }

    public static Optional<DimensionType> getDimensionType(Class<? extends WorldProvider> providerClass) {
        Preconditions.checkNotNull(providerClass);
        for (Object e : dimensionTypeByTypeId.values()) {
            DimensionType dimensionType = (DimensionType)e;
            if (!((org.spongepowered.api.world.DimensionType)dimensionType).getDimensionClass().equals(providerClass)) continue;
            return Optional.of(dimensionType);
        }
        return Optional.empty();
    }

    public static Collection<DimensionType> getDimensionTypes() {
        return dimensionTypeByTypeId.values();
    }

    public static int[] getRegisteredDimensionIdsFor(DimensionType type) {
        return dimensionTypeByDimensionId.int2ReferenceEntrySet().stream().filter(entry -> entry.getValue() == type).mapToInt(Int2ReferenceMap.Entry::getIntKey).toArray();
    }

    public static int[] getRegisteredDimensionIds() {
        return dimensionTypeByDimensionId.keySet().toIntArray();
    }

    @Nullable
    private static Path getWorldFolder(DimensionType dimensionType, int dimensionId) {
        return (Path)dimensionPathByDimensionId.get(dimensionId);
    }

    public static boolean isDimensionRegistered(int dimensionId) {
        return dimensionTypeByDimensionId.containsKey(dimensionId);
    }

    private static Int2ReferenceMap<DimensionType> sortedDimensionMap() {
        Int2ReferenceOpenHashMap<DimensionType> copy = new Int2ReferenceOpenHashMap<DimensionType>(dimensionTypeByDimensionId);
        Int2ReferenceLinkedOpenHashMap<DimensionType> newMap = new Int2ReferenceLinkedOpenHashMap<DimensionType>();
        newMap.put(0, (DimensionType)copy.remove(0));
        DimensionType removed = (DimensionType)copy.remove(-1);
        if (removed != null) {
            newMap.put(-1, removed);
        }
        if ((removed = (DimensionType)copy.remove(1)) != null) {
            newMap.put(1, removed);
        }
        int[] ids = copy.keySet().toIntArray();
        Arrays.sort(ids);
        for (int id : ids) {
            newMap.put(id, (DimensionType)copy.get(id));
        }
        return newMap;
    }

    public static ObjectIterator<Int2ObjectMap.Entry<WorldServer>> worldsIterator() {
        return worldByDimensionId.int2ObjectEntrySet().fastIterator();
    }

    public static Collection<WorldServer> getWorlds() {
        return worldByDimensionId.values();
    }

    public static Optional<WorldServer> getWorldByDimensionId(int dimensionId) {
        return Optional.ofNullable(worldByDimensionId.get(dimensionId));
    }

    public static Optional<String> getWorldFolderByDimensionId(int dimensionId) {
        return Optional.ofNullable(worldFolderByDimensionId.get(dimensionId));
    }

    public static int[] getLoadedWorldDimensionIds() {
        return worldByDimensionId.keySet().toIntArray();
    }

    public static Optional<WorldServer> getWorld(String worldName) {
        for (WorldServer worldServer : WorldManager.getWorlds()) {
            World apiWorld = (World)worldServer;
            if (!apiWorld.getName().equals(worldName)) continue;
            return Optional.of(worldServer);
        }
        return Optional.empty();
    }

    private static void registerWorldProperties(WorldProperties properties) {
        Preconditions.checkNotNull(properties);
        worldPropertiesByFolderName.put(properties.getWorldName(), properties);
        worldPropertiesByWorldUuid.put(properties.getUniqueId(), properties);
        worldUuidByFolderName.put(properties.getWorldName(), properties.getUniqueId());
        Integer dimensionId = ((WorldInfoBridge)((Object)properties)).bridge$getDimensionId();
        worldFolderByDimensionId.put(dimensionId, properties.getWorldName());
        usedDimensionIds.add(dimensionId);
    }

    public static void unregisterWorldProperties(WorldProperties properties, boolean freeDimensionId) {
        Preconditions.checkNotNull(properties);
        worldPropertiesByFolderName.remove(properties.getWorldName());
        worldPropertiesByWorldUuid.remove(properties.getUniqueId());
        worldUuidByFolderName.remove(properties.getWorldName());
        Integer dimensionId = ((WorldInfoBridge)((Object)properties)).bridge$getDimensionId();
        worldFolderByDimensionId.remove(dimensionId);
        if (dimensionId != null && freeDimensionId) {
            usedDimensionIds.remove(dimensionId);
        }
    }

    public static void unregisterAllWorldSettings() {
        worldPropertiesByFolderName.clear();
        worldPropertiesByWorldUuid.clear();
        worldUuidByFolderName.clear();
        worldByDimensionId.clear();
        worldFolderByDimensionId.clear();
        dimensionTypeByDimensionId.clear();
        dimensionPathByDimensionId.clear();
        usedDimensionIds.clear();
        weakWorldByWorld.clear();
        isVanillaRegistered = false;
        WorldManager.registerVanillaTypesAndDimensions();
    }

    public static Optional<WorldProperties> getWorldProperties(String folderName) {
        Preconditions.checkNotNull(folderName);
        return Optional.ofNullable(worldPropertiesByFolderName.get(folderName));
    }

    public static Collection<WorldProperties> getAllWorldProperties() {
        return Collections.unmodifiableCollection(worldPropertiesByFolderName.values());
    }

    public static Optional<WorldProperties> getWorldProperties(UUID uuid) {
        Preconditions.checkNotNull(uuid);
        return Optional.ofNullable(worldPropertiesByWorldUuid.get(uuid));
    }

    public static Optional<UUID> getUuidForFolder(String folderName) {
        Preconditions.checkNotNull(folderName);
        return Optional.ofNullable(worldUuidByFolderName.get(folderName));
    }

    public static Optional<String> getFolderForUuid(UUID uuid) {
        Preconditions.checkNotNull(uuid);
        return Optional.ofNullable(worldUuidByFolderName.inverse().get(uuid));
    }

    public static WorldProperties createWorldProperties(String folderName, WorldArchetype archetype) {
        return WorldManager.createWorldProperties(folderName, archetype, null);
    }

    public static WorldProperties createWorldProperties(String folderName, WorldArchetype archetype, @Nullable Integer dimensionId) {
        AnvilSaveHandler saveHandler;
        Preconditions.checkNotNull(folderName);
        Preconditions.checkNotNull(archetype);
        Optional<WorldServer> optWorldServer = WorldManager.getWorld(folderName);
        if (optWorldServer.isPresent()) {
            return ((World)optWorldServer.get()).getProperties();
        }
        Optional<WorldProperties> optWorldProperties = WorldManager.getWorldProperties(folderName);
        if (optWorldProperties.isPresent()) {
            return optWorldProperties.get();
        }
        try (Object ignore = GeneralPhase.State.SAVE_HANDLER_CREATION.createPhaseContext().createFiles(!archetype.getSerializationBehavior().equals(SerializationBehaviors.NONE)).buildAndSwitch();){
            saveHandler = new AnvilSaveHandler(WorldManager.getCurrentSavesDirectory().get().toFile(), folderName, true, ((MinecraftServerAccessor)((Object)SpongeImpl.getServer())).accessor$getDataFixer());
        }
        WorldInfo worldInfo = saveHandler.func_75757_d();
        if (worldInfo == null) {
            worldInfo = new WorldInfo((WorldSettings)archetype, folderName);
            if (archetype.isSeedRandomized()) {
                ((WorldProperties)worldInfo).setSeed(SpongeImpl.random.nextLong());
            }
        } else {
            ((WorldInfoBridge)worldInfo).bridge$setDimensionType(archetype.getDimensionType());
            ((WorldInfoBridge)worldInfo).bridge$createWorldConfig();
            ((WorldProperties)worldInfo).setGeneratorModifiers(archetype.getGeneratorModifiers());
        }
        WorldManager.setUuidOnProperties(WorldManager.getCurrentSavesDirectory().get(), (WorldProperties)worldInfo);
        if (dimensionId != null) {
            ((WorldInfoBridge)worldInfo).bridge$setDimensionId(dimensionId);
        } else if (((WorldInfoBridge)worldInfo).bridge$getDimensionId() == null || WorldManager.getWorldByDimensionId(((WorldInfoBridge)worldInfo).bridge$getDimensionId()).isPresent()) {
            ((WorldInfoBridge)worldInfo).bridge$setDimensionId(WorldManager.getNextFreeDimensionId());
        }
        ((WorldProperties)worldInfo).setGeneratorType(archetype.getGeneratorType());
        ((WorldInfoBridge)worldInfo).bridge$getConfigAdapter().save();
        WorldManager.registerWorldProperties((WorldProperties)worldInfo);
        SpongeImpl.postEvent(SpongeEventFactory.createConstructWorldPropertiesEvent(Sponge.getCauseStackManager().getCurrentCause(), archetype, (WorldProperties)worldInfo));
        if (archetype.getSerializationBehavior() != SerializationBehaviors.NONE) {
            saveHandler.func_75755_a(worldInfo, SpongeImpl.getServer().func_184103_al().func_72378_q());
        }
        return (WorldProperties)worldInfo;
    }

    public static boolean saveWorldProperties(WorldProperties properties) {
        Preconditions.checkNotNull(properties);
        Optional<WorldServer> optWorldServer = WorldManager.getWorldByDimensionId(((WorldInfoBridge)((Object)properties)).bridge$getDimensionId());
        if (optWorldServer.isPresent()) {
            WorldServer worldServer = optWorldServer.get();
            worldServer.func_72860_G().func_75761_a((WorldInfo)properties);
            worldServer.func_72860_G().func_75757_d();
        } else {
            new AnvilSaveHandler(WorldManager.getCurrentSavesDirectory().get().toFile(), properties.getWorldName(), true, ((MinecraftServerAccessor)((Object)SpongeImpl.getServer())).accessor$getDataFixer()).func_75761_a((WorldInfo)properties);
        }
        ((WorldInfoBridge)((Object)properties)).bridge$getConfigAdapter().save();
        return true;
    }

    public static void unloadQueuedWorlds() {
        WorldServer server;
        while ((server = unloadQueue.poll()) != null) {
            WorldManager.unloadWorld(server, true, false);
        }
        unloadQueue.clear();
    }

    public static void queueWorldToUnload(WorldServer worldServer) {
        Preconditions.checkNotNull(worldServer);
        unloadQueue.add(worldServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unloadWorld(WorldServer worldServer, boolean checkConfig, boolean isShuttingDown) {
        Preconditions.checkNotNull(worldServer);
        MinecraftServer server = SpongeImpl.getServer();
        if (!worldByDimensionId.containsValue(worldServer)) {
            return false;
        }
        if (!isShuttingDown) {
            if (!worldServer.field_73010_i.isEmpty()) {
                return false;
            }
            if (checkConfig && ((WorldProperties)worldServer.func_72912_H()).doesKeepSpawnLoaded()) {
                return false;
            }
        }
        SpongeConfig<GlobalConfig> globalConfigAdapter = SpongeImpl.getGlobalConfigAdapter();
        try (Object ignored = ((PhaseContext)GeneralPhase.State.WORLD_UNLOAD.createPhaseContext()).source(worldServer);){
            ((PhaseContext)ignored).buildAndSwitch();
            UnloadWorldEvent event = SpongeEventFactory.createUnloadWorldEvent(Sponge.getCauseStackManager().getCurrentCause(), (World)worldServer);
            boolean isCancelled = SpongeImpl.postEvent(event);
            if (!isShuttingDown && isCancelled) {
                boolean bl2 = false;
                return bl2;
            }
            WorldServerBridge mixinWorldServer = (WorldServerBridge)worldServer;
            int dimensionId = mixinWorldServer.bridge$getDimensionId();
            SpongeImpl.getLogger().info("Unloading world [{}] ({}/{})", (Object)worldServer.func_72912_H().func_76065_j(), (Object)((World)worldServer).getDimension().getType().getId(), (Object)dimensionId);
            try {
                try {
                    if (globalConfigAdapter.getConfig().getModules().useOptimizations() && globalConfigAdapter.getConfig().getOptimizations().useAsyncLighting()) {
                        ((WorldServerBridge_AsyncLighting)worldServer).asyncLightingBridge$getLightingExecutor().shutdownNow();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!isShuttingDown) {
                    WorldManager.saveWorld(worldServer, true);
                }
                ((WorldInfoBridge)worldServer.func_72912_H()).bridge$getConfigAdapter().save();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                worldByDimensionId.remove(dimensionId);
                weakWorldByWorld.remove(worldServer);
                ((MinecraftServerBridge)((Object)server)).bridge$removeWorldTickTimes(dimensionId);
                WorldManager.reorderWorldsVanillaFirst();
            }
        }
        return true;
    }

    public static void saveWorld(WorldServer worldServer, boolean flush) throws MinecraftException {
        if (((WorldProperties)worldServer.func_72912_H()).getSerializationBehavior() != SerializationBehaviors.NONE) {
            worldServer.func_73044_a(true, null);
        }
        if (flush) {
            worldServer.func_73041_k();
        }
    }

    public static Optional<WorldServer> loadWorld(UUID uuid) {
        Preconditions.checkNotNull(uuid);
        Optional<World> optWorld = Sponge.getServer().getWorld(uuid);
        if (optWorld.isPresent()) {
            return Optional.of((WorldServer)optWorld.get());
        }
        String worldFolder = (String)worldUuidByFolderName.inverse().get(uuid);
        if (worldFolder == null) {
            return Optional.empty();
        }
        return WorldManager.loadWorld(worldFolder, null);
    }

    public static Optional<WorldServer> loadWorld(String worldName) {
        Preconditions.checkNotNull(worldName);
        return WorldManager.loadWorld(worldName, null);
    }

    public static Optional<WorldServer> loadWorld(WorldProperties properties) {
        Preconditions.checkNotNull(properties);
        return WorldManager.loadWorld(properties.getWorldName(), properties);
    }

    private static Optional<WorldServer> loadWorld(String worldName, @Nullable WorldProperties properties) {
        AnvilSaveHandler saveHandler;
        Preconditions.checkNotNull(worldName);
        Path currentSavesDir = WorldManager.getCurrentSavesDirectory().orElseThrow(() -> new IllegalStateException("Attempt made to load world too early!"));
        MinecraftServer server = SpongeImpl.getServer();
        Optional<WorldServer> optExistingWorldServer = WorldManager.getWorld(worldName);
        if (optExistingWorldServer.isPresent()) {
            return optExistingWorldServer;
        }
        if (!server.func_71255_r()) {
            SpongeImpl.getLogger().error("Unable to load world [{}]. Multi-world is disabled via [allow-nether] in [server.properties].", (Object)worldName);
            return Optional.empty();
        }
        boolean filesShouldExist = properties == null || properties.getSerializationBehavior() != SerializationBehaviors.NONE;
        Path worldFolder = currentSavesDir.resolve(worldName);
        if (!Files.isDirectory(worldFolder, new LinkOption[0]) && filesShouldExist) {
            SpongeImpl.getLogger().error("Unable to load world [{}]. We cannot find its folder under [{}].", (Object)worldFolder, (Object)currentSavesDir);
            return Optional.empty();
        }
        try (Object ignore = GeneralPhase.State.SAVE_HANDLER_CREATION.createPhaseContext().createFiles(filesShouldExist).buildAndSwitch();){
            saveHandler = new AnvilSaveHandler(currentSavesDir.toFile(), worldName, true, ((MinecraftServerAccessor)((Object)SpongeImpl.getServer())).accessor$getDataFixer());
        }
        if (properties == null && (properties = (WorldProperties)saveHandler.func_75757_d()) == null) {
            SpongeImpl.getLogger().error("Unable to load world [{}]. No world properties was found!", (Object)worldName);
            return Optional.empty();
        }
        Integer dimensionId = ((WorldInfoBridge)((Object)properties)).bridge$getDimensionId();
        if (dimensionId == null) {
            dimensionId = WorldManager.getNextFreeDimensionId();
            ((WorldInfoBridge)((Object)properties)).bridge$setDimensionId(dimensionId);
        }
        WorldManager.setUuidOnProperties(WorldManager.getCurrentSavesDirectory().get(), properties);
        WorldManager.registerWorldProperties(properties);
        WorldInfo worldInfo = (WorldInfo)properties;
        ((WorldInfoBridge)worldInfo).bridge$createWorldConfig();
        if (!((WorldProperties)worldInfo).isEnabled()) {
            SpongeImpl.getLogger().error("Unable to load world [{}] ({}/{}). It is disabled.", (Object)properties.getWorldName(), (Object)properties.getDimensionType().getId(), (Object)dimensionId);
            return Optional.empty();
        }
        WorldManager.registerDimension(dimensionId, (DimensionType)properties.getDimensionType());
        WorldManager.registerDimensionPath(dimensionId, worldFolder);
        SpongeImpl.getLogger().info("Loading world [{}] ({}/{})", (Object)properties.getWorldName(), (Object)properties.getDimensionType().getId(), (Object)dimensionId);
        WorldServer worldServer = WorldManager.createWorldFromProperties(dimensionId, (ISaveHandler)saveHandler, (WorldInfo)properties, new WorldSettings((WorldInfo)properties));
        WorldManager.reorderWorldsVanillaFirst();
        return Optional.of(worldServer);
    }

    public static void loadAllWorlds(long defaultSeed, WorldType defaultWorldType, String generatorOptions) {
        MinecraftServer server = SpongeImpl.getServer();
        Path currentSavesDir = WorldManager.getCurrentSavesDirectory().get();
        try {
            if (Files.isSymbolicLink(currentSavesDir)) {
                Path actualPathLink = Files.readSymbolicLink(currentSavesDir);
                if (Files.notExists(actualPathLink, new LinkOption[0])) {
                    Files.createDirectories(actualPathLink, new FileAttribute[0]);
                } else if (!Files.isDirectory(actualPathLink, new LinkOption[0])) {
                    throw new IOException("Saves directory [" + currentSavesDir + "] symlink to [" + actualPathLink + "] is not a directory!");
                }
            } else {
                Files.createDirectories(currentSavesDir, new FileAttribute[0]);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        WorldManager.registerVanillaDimensionPaths(currentSavesDir);
        if (MIGRATE_WORLDS) {
            WorldMigrator.migrateWorldsTo(currentSavesDir);
        } else {
            SpongeImpl.getLogger().info("World migration is disabled. Old worlds will not be migrated...");
        }
        WorldManager.registerExistingSpongeDimensions(currentSavesDir);
        for (Int2ReferenceMap.Entry entry : WorldManager.sortedDimensionMap().int2ReferenceEntrySet()) {
            String previousWorldForUUID;
            WorldSettings worldSettings;
            SpongeConfig<? extends GeneralConfigBase> spongeConfig;
            int dimensionId = entry.getIntKey();
            DimensionType dimensionType = (DimensionType)entry.getValue();
            org.spongepowered.api.world.DimensionType apiDimensionType = (org.spongepowered.api.world.DimensionType)dimensionType;
            if (dimensionId != 0 && !server.func_71255_r() || WorldManager.getWorldByDimensionId(dimensionId).isPresent()) continue;
            Path worldFolder = WorldManager.getWorldFolder(dimensionType, dimensionId);
            if (worldFolder == null) {
                SpongeImpl.getLogger().error("An attempt was made to load a world in dimension [{}] ({}) that has no registered world folder!", (Object)apiDimensionType.getId(), (Object)dimensionId);
                continue;
            }
            String worldFolderName = worldFolder.getFileName().toString();
            if (dimensionId != 0 && !(spongeConfig = SpongeHooks.getConfigAdapter(((DimensionTypeBridge)dimensionType).bridge$getConfigPath(), worldFolderName)).getConfig().getWorld().isWorldEnabled()) {
                SpongeImpl.getLogger().warn("World [{}] ({}/{}) is disabled. World will not be loaded...", (Object)worldFolder, (Object)apiDimensionType.getId(), (Object)dimensionId);
                continue;
            }
            Object saveHandler = dimensionId == 0 ? server.func_71254_M().func_75804_a(server.func_71270_I(), true) : new AnvilSaveHandler(WorldManager.getCurrentSavesDirectory().get().toFile(), worldFolderName, true, ((MinecraftServerAccessor)((Object)SpongeImpl.getServer())).accessor$getDataFixer());
            WorldInfo worldInfo = saveHandler.func_75757_d();
            if (server instanceof IntegratedServerBridge) {
                worldSettings = ((IntegratedServerBridge)((Object)server)).bridge$getSettings();
                if (dimensionId == 0 && ((IntegratedServerBridge)((Object)server)).bridge$isNewSave()) {
                    SpongeImpl.postEvent(SpongeEventFactory.createConstructWorldPropertiesEvent(Sponge.getCauseStackManager().getCurrentCause(), (WorldArchetype)worldSettings, (WorldProperties)worldInfo));
                }
            } else {
                worldSettings = new WorldSettings(defaultSeed, server.func_71265_f(), server.func_71225_e(), server.func_71199_h(), defaultWorldType);
            }
            if (worldInfo == null) {
                worldInfo = WorldManager.createWorldInfoFromSettings(currentSavesDir, apiDimensionType, dimensionId, worldFolderName, worldSettings, generatorOptions);
            } else {
                ((WorldInfoBridge)worldInfo).bridge$setDimensionType(apiDimensionType);
                ((WorldInfoBridge)worldInfo).bridge$createWorldConfig();
                ((WorldProperties)worldInfo).setGenerateSpawnOnLoad(((DimensionTypeBridge)dimensionType).bridge$shouldGenerateSpawnOnLoad());
                if (((WorldInfoBridge)worldInfo).bridge$getDimensionId() == null) {
                    ((WorldInfoBridge)worldInfo).bridge$setDimensionId(dimensionId);
                }
            }
            UUID uniqueId = ((WorldProperties)worldInfo).getUniqueId();
            if (uniqueId == null) {
                WorldManager.setUuidOnProperties(dimensionId == 0 ? currentSavesDir.getParent() : currentSavesDir, (WorldProperties)worldInfo);
                uniqueId = ((WorldProperties)worldInfo).getUniqueId();
            }
            if ((previousWorldForUUID = (String)worldUuidByFolderName.inverse().get(uniqueId)) != null) {
                SpongeImpl.getLogger().error("UUID [{}] has already been registered by world [{}] but is attempting to be registered by world [{}]. This means worlds have been copied outside of Sponge. Skipping world load...", (Object)uniqueId, (Object)previousWorldForUUID, (Object)worldInfo.func_76065_j());
                continue;
            }
            if (!worldInfo.func_76065_j().equals(worldFolderName)) {
                worldInfo.func_76062_a(worldFolderName);
            }
            if (dimensionId == 0) {
                ((MinecraftServerAccessor)((Object)server)).accessor$setResourcePackFromWorld(worldFolderName, (ISaveHandler)saveHandler);
            }
            WorldManager.registerWorldProperties((WorldProperties)worldInfo);
            if (dimensionId != 0 && !((WorldProperties)worldInfo).loadOnStartup()) {
                SpongeImpl.getLogger().warn("World [{}] ({}/{}) is set to not load on startup. To load it later, enable [load-on-startup] in config or use a plugin.", (Object)worldInfo.func_76065_j(), (Object)apiDimensionType.getId(), (Object)dimensionId);
                continue;
            }
            WorldServer worldServer = WorldManager.createWorldFromProperties(dimensionId, saveHandler, worldInfo, worldSettings);
            SpongeImpl.getLogger().info("Loading world [{}] ({}/{})", (Object)((World)worldServer).getName(), (Object)apiDimensionType.getId(), (Object)dimensionId);
        }
        WorldManager.reorderWorldsVanillaFirst();
    }

    private static WorldInfo createWorldInfoFromSettings(Path currentSaveRoot, org.spongepowered.api.world.DimensionType dimensionType, int dimensionId, String worldFolderName, WorldSettings worldSettings, String generatorOptions) {
        worldSettings.func_82750_a(generatorOptions);
        ((WorldSettingsBridge)worldSettings).bridge$setDimensionType(dimensionType);
        ((WorldSettingsBridge)worldSettings).bridge$setGenerateSpawnOnLoad(((DimensionTypeBridge)((Object)dimensionType)).bridge$shouldGenerateSpawnOnLoad());
        WorldInfo worldInfo = new WorldInfo(worldSettings, worldFolderName);
        WorldManager.setUuidOnProperties(dimensionId == 0 ? currentSaveRoot.getParent() : currentSaveRoot, (WorldProperties)worldInfo);
        ((WorldInfoBridge)worldInfo).bridge$setDimensionId(dimensionId);
        SpongeImpl.postEvent(SpongeEventFactory.createConstructWorldPropertiesEvent(Sponge.getCauseStackManager().getCurrentCause(), (WorldArchetype)worldSettings, (WorldProperties)worldInfo));
        return worldInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WorldServer createWorldFromProperties(int dimensionId, ISaveHandler saveHandler, WorldInfo worldInfo, @Nullable WorldSettings worldSettings) {
        MinecraftServer server = SpongeImpl.getServer();
        WorldServer worldServer = new WorldServer(server, saveHandler, worldInfo, dimensionId, server.field_71304_b);
        worldByDimensionId.put(dimensionId, worldServer);
        weakWorldByWorld.put(worldServer, worldServer);
        WorldManager.reorderWorldsVanillaFirst();
        ((MinecraftServerBridge)((Object)server)).bridge$putWorldTickTimes(dimensionId, new long[100]);
        worldServer.func_175643_b();
        worldServer.func_72954_a((IWorldEventListener)new ServerWorldEventHandler(server, worldServer));
        if (!server.func_71264_H() && worldServer.func_72912_H().func_76077_q() == GameType.NOT_SET) {
            worldServer.func_72912_H().func_76060_a(server.func_71265_f());
        }
        ((ChunkProviderServerBridge)worldServer.func_72863_F()).bridge$setForceChunkRequests(true);
        try {
            SpongeImpl.postEvent(SpongeEventFactory.createLoadWorldEvent(Sponge.getCauseStackManager().getCurrentCause(), (World)worldServer));
            if (worldSettings != null) {
                worldServer.func_72963_a(worldSettings);
            }
            if (((DimensionTypeBridge)((Object)((World)worldServer).getDimension().getType())).bridge$shouldLoadSpawn()) {
                ((MinecraftServerBridge)((Object)server)).bridge$prepareSpawnArea(worldServer);
            }
            ((WorldBridge)worldServer).bridge$clearFakeCheck();
            WorldServer worldServer2 = worldServer;
            return worldServer2;
        }
        finally {
            ((ChunkProviderServerBridge)worldServer.func_72863_F()).bridge$setForceChunkRequests(false);
        }
    }

    public static boolean mkdirsIfSaveable(File dir) {
        IPhaseState<?> state;
        if (PhaseTracker.getInstance().getSidedThread() == Thread.currentThread() && !(state = PhaseTracker.getInstance().getCurrentState()).shouldCreateWorldDirectories(PhaseTracker.getInstance().getCurrentContext())) {
            return false;
        }
        Path path = dir.toPath();
        Optional<Path> savesDirOpt = WorldManager.getCurrentSavesDirectory();
        if (!savesDirOpt.isPresent()) {
            return dir.mkdirs();
        }
        Path savesDir = savesDirOpt.get();
        if (path.startsWith(savesDir) && !path.equals(savesDir)) {
            WorldProperties props;
            Path worldName = savesDir.relativize(path).getName(0);
            if (worldPropertiesByFolderName.containsKey(worldName.toString())) {
                props = worldPropertiesByFolderName.get(worldName.toString());
            } else if (worldPropertiesByWorldUuid.size() == 1) {
                props = worldPropertiesByWorldUuid.values().iterator().next();
            } else {
                Optional<WorldProperties> overworld = Sponge.getServer().getDefaultWorld();
                if (!overworld.isPresent()) {
                    return dir.mkdirs();
                }
                props = overworld.get();
            }
            if (props.getSerializationBehavior() == SerializationBehaviors.NONE) {
                return false;
            }
        }
        return dir.mkdirs();
    }

    public static void forceAddWorld(int dimensionId, WorldServer worldServer) {
        worldByDimensionId.put(dimensionId, worldServer);
        weakWorldByWorld.put(worldServer, worldServer);
        ((MinecraftServerBridge)((Object)SpongeImpl.getServer())).bridge$putWorldTickTimes(dimensionId, new long[100]);
    }

    public static void reorderWorldsVanillaFirst() {
        LinkedList<Object> sorted = new LinkedList<Object>();
        ArrayList<Integer> vanillaWorldIds = new ArrayList<Integer>();
        WorldServer worldServer = worldByDimensionId.get(0);
        if (worldServer != null) {
            vanillaWorldIds.add(0);
            sorted.add(worldServer);
        }
        if ((worldServer = worldByDimensionId.get(-1)) != null) {
            vanillaWorldIds.add(-1);
            sorted.add(worldServer);
        }
        if ((worldServer = worldByDimensionId.get(1)) != null) {
            vanillaWorldIds.add(1);
            sorted.add(worldServer);
        }
        ArrayList<WorldServer> worlds = new ArrayList<WorldServer>(worldByDimensionId.values());
        Iterator iterator = worlds.iterator();
        while (iterator.hasNext()) {
            WorldServerBridge mixinWorld = (WorldServerBridge)iterator.next();
            int dimensionId = mixinWorld.bridge$getDimensionId();
            if (!vanillaWorldIds.contains(dimensionId)) continue;
            iterator.remove();
        }
        worlds.sort(WORLD_SERVER_COMPARATOR);
        sorted.addAll(worlds);
        SpongeImpl.getServer().field_71305_c = sorted.toArray(new WorldServer[0]);
    }

    private static void setUuidOnProperties(Path savesRoot, WorldProperties properties) {
        UUID uuid;
        Preconditions.checkNotNull(properties);
        if (properties.getUniqueId() == null || properties.getUniqueId().equals(Constants.World.INVALID_WORLD_UUID)) {
            Path uidPath = savesRoot.resolve(properties.getWorldName()).resolve("uid.dat");
            if (Files.notExists(uidPath, new LinkOption[0])) {
                uuid = UUID.randomUUID();
            } else {
                try (DataInputStream dis = new DataInputStream(Files.newInputStream(uidPath, new OpenOption[0]));){
                    uuid = new UUID(dis.readLong(), dis.readLong());
                }
                catch (IOException e) {
                    SpongeImpl.getLogger().error("World folder [{}] has an existing Bukkit unique identifier for it but we encountered issues parsing the file. We will have to use a new unique id. Please report this to Sponge ASAP.", (Object)properties.getWorldName(), (Object)e);
                    uuid = UUID.randomUUID();
                }
            }
        } else {
            uuid = properties.getUniqueId();
        }
        ((WorldInfoBridge)((Object)properties)).bridge$setUniqueId(uuid);
    }

    private static void registerExistingSpongeDimensions(Path rootPath) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(rootPath, LEVEL_AND_SPONGE);){
            for (Path worldPath : stream) {
                NBTTagCompound compound;
                Path spongeLevelPath = worldPath.resolve("level_sponge.dat");
                String worldFolderName = worldPath.getFileName().toString();
                try {
                    compound = CompressedStreamTools.func_74796_a((InputStream)Files.newInputStream(spongeLevelPath, new OpenOption[0]));
                }
                catch (IOException e) {
                    SpongeImpl.getLogger().error("Failed loading Sponge data for World [{}]}. Report to Sponge ASAP.", (Object)worldFolderName, (Object)e);
                    continue;
                }
                NBTTagCompound spongeDataCompound = compound.func_74775_l("SpongeData");
                if (!compound.func_74764_b("SpongeData")) {
                    SpongeImpl.getLogger().error("World [{}] has Sponge related data in the form of [level-sponge.dat] but the structure is not proper. Generally, the data is within a [{}] tag but it is not for this world. Report to Sponge ASAP.", (Object)worldFolderName, (Object)"SpongeData");
                    continue;
                }
                if (!spongeDataCompound.func_74764_b("dimensionId")) {
                    SpongeImpl.getLogger().error("World [{}] has no dimension id. Report this to Sponge ASAP.", (Object)worldFolderName);
                    continue;
                }
                int dimensionId = (spongeDataCompound = DataUtil.spongeDataFixer.func_188257_a((IFixType)FixTypes.LEVEL, spongeDataCompound)).func_74762_e("dimensionId");
                if (dimensionId == 0 || dimensionId == -1 || dimensionId == 1) continue;
                if (dimensionTypeByDimensionId.containsKey(dimensionId)) {
                    SpongeImpl.getLogger().warn("World [{}] ({}) is attempting to be registered as an existing dimension but it's dimension id has already been registered for folder [{}]. This means the world has been copied outside of Sponge. This is not a supported configuration.", (Object)worldFolderName, (Object)dimensionId, worldFolderByDimensionId.get(dimensionId));
                    continue;
                }
                if (!spongeDataCompound.func_186855_b("UUID")) {
                    SpongeImpl.getLogger().error("World [{}] ({}) has no valid unique identifier. Report this to Sponge ASAP.", (Object)worldFolderName, (Object)dimensionId);
                    continue;
                }
                String dimensionTypeId = "overworld";
                if (spongeDataCompound.func_74764_b("dimensionType")) {
                    dimensionTypeId = spongeDataCompound.func_74779_i("dimensionType");
                } else {
                    SpongeImpl.getLogger().warn("World [{}] ({}) has no specified dimension type. Defaulting to [{}}]...", (Object)worldFolderName, (Object)dimensionId, (Object)DimensionTypes.OVERWORLD.getName());
                }
                dimensionTypeId = WorldManager.fixDimensionTypeId(dimensionTypeId);
                org.spongepowered.api.world.DimensionType dimensionType = Sponge.getRegistry().getType(org.spongepowered.api.world.DimensionType.class, dimensionTypeId).orElse(null);
                if (dimensionType == null) {
                    SpongeImpl.getLogger().warn("World [{}] ({}) has specified dimension type that is not registered. Skipping...", (Object)worldFolderName, (Object)dimensionId);
                    continue;
                }
                spongeDataCompound.func_74778_a("dimensionType", dimensionTypeId);
                worldFolderByDimensionId.put(dimensionId, worldFolderName);
                WorldManager.registerDimensionPath(dimensionId, rootPath.resolve(worldFolderName));
                WorldManager.registerDimension(dimensionId, (DimensionType)dimensionType);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String fixDimensionTypeId(String name) {
        if (!name.contains(":")) {
            for (org.spongepowered.api.world.DimensionType type : Sponge.getRegistry().getAllOf(org.spongepowered.api.world.DimensionType.class)) {
                String typeId = type.getId().substring(type.getId().lastIndexOf(":") + 1);
                if (!typeId.equals(name)) continue;
                return type.getId();
            }
        }
        return name;
    }

    public static CompletableFuture<Optional<WorldProperties>> copyWorld(WorldProperties worldProperties, String copyName) {
        Preconditions.checkArgument(worldPropertiesByFolderName.containsKey(worldProperties.getWorldName()), "World properties not registered!");
        Preconditions.checkArgument(!worldPropertiesByFolderName.containsKey(copyName), "Destination world name already is registered!");
        WorldInfo info = (WorldInfo)worldProperties;
        WorldServer worldServer = worldByDimensionId.get((int)((WorldInfoBridge)info).bridge$getDimensionId());
        if (worldServer != null) {
            try {
                WorldManager.saveWorld(worldServer, true);
            }
            catch (MinecraftException e) {
                throw new RuntimeException(e);
            }
            ((MinecraftServerBridge)((Object)SpongeImpl.getServer())).bridge$setSaveEnabled(false);
        }
        CompletableFuture<Optional<WorldProperties>> future = SpongeImpl.getScheduler().submitAsyncTask(new CopyWorldTask(info, copyName));
        if (worldServer != null) {
            future.thenRun(() -> ((MinecraftServerBridge)((Object)SpongeImpl.getServer())).bridge$setSaveEnabled(true));
        }
        return future;
    }

    public static Optional<WorldProperties> renameWorld(WorldProperties worldProperties, String newName) {
        Preconditions.checkNotNull(worldProperties);
        Preconditions.checkNotNull(newName);
        Preconditions.checkState(!worldByDimensionId.containsKey(((WorldInfoBridge)((Object)worldProperties)).bridge$getDimensionId()), "World is still loaded!");
        Path oldWorldFolder = WorldManager.getCurrentSavesDirectory().get().resolve(worldProperties.getWorldName());
        Path newWorldFolder = oldWorldFolder.resolveSibling(newName);
        if (Files.exists(newWorldFolder, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            Files.move(oldWorldFolder, newWorldFolder, new CopyOption[0]);
        }
        catch (IOException e) {
            SpongeImpl.getLogger().error("Failed to move world folder " + worldProperties.getWorldName(), (Throwable)e);
            return Optional.empty();
        }
        WorldManager.unregisterWorldProperties(worldProperties, false);
        WorldInfo info = new WorldInfo((WorldInfo)worldProperties);
        info.func_76062_a(newName);
        ((WorldInfoBridge)info).bridge$setUniqueId(worldProperties.getUniqueId());
        if (((WorldInfoBridge)((Object)worldProperties)).bridge$getDimensionId() != null) {
            ((WorldInfoBridge)info).bridge$setDimensionId(((WorldInfoBridge)((Object)worldProperties)).bridge$getDimensionId());
        }
        ((WorldInfoBridge)info).bridge$createWorldConfig();
        new AnvilSaveHandler(WorldManager.getCurrentSavesDirectory().get().toFile(), newName, true, ((MinecraftServerAccessor)((Object)SpongeImpl.getServer())).accessor$getDataFixer()).func_75761_a(info);
        WorldManager.registerWorldProperties((WorldProperties)info);
        return Optional.of((WorldProperties)info);
    }

    public static CompletableFuture<Boolean> deleteWorld(WorldProperties worldProperties) {
        Preconditions.checkNotNull(worldProperties);
        Preconditions.checkArgument(worldPropertiesByWorldUuid.containsKey(worldProperties.getUniqueId()), "World properties not registered!");
        Preconditions.checkState(!worldByDimensionId.containsKey(((WorldInfoBridge)((Object)worldProperties)).bridge$getDimensionId()), "World not unloaded!");
        return SpongeImpl.getScheduler().submitAsyncTask(new DeleteWorldTask(worldProperties));
    }

    public static void updateServerDifficulty() {
        EnumDifficulty serverDifficulty = SpongeImpl.getServer().func_147135_j();
        Iterator<WorldServer> iterator = WorldManager.getWorlds().iterator();
        while (iterator.hasNext()) {
            WorldServer worldServer;
            boolean alreadySet = ((WorldInfoBridge)(worldServer = iterator.next()).func_72912_H()).bridge$hasCustomDifficulty();
            WorldManager.adjustWorldForDifficulty(worldServer, alreadySet ? worldServer.func_72912_H().func_176130_y() : serverDifficulty, false);
        }
    }

    public static void adjustWorldForDifficulty(WorldServer worldServer, EnumDifficulty difficulty, boolean isCustom) {
        MinecraftServer server = SpongeImpl.getServer();
        if (worldServer.func_72912_H().func_76093_s()) {
            difficulty = EnumDifficulty.HARD;
            worldServer.func_72891_a(true, true);
        } else if (SpongeImpl.getServer().func_71264_H()) {
            worldServer.func_72891_a(worldServer.func_175659_aa() != EnumDifficulty.PEACEFUL, true);
        } else {
            worldServer.func_72891_a(server.func_71193_K(), server.func_71268_U());
        }
        if (isCustom) {
            worldServer.func_72912_H().func_176144_a(difficulty);
        } else if (!((WorldInfoBridge)worldServer.func_72912_H()).bridge$hasCustomDifficulty()) {
            ((WorldInfoBridge)worldServer.func_72912_H()).bridge$forceSetDifficulty(difficulty);
        }
    }

    public static void sendDimensionRegistration(EntityPlayerMP playerMP, WorldProvider provider) {
    }

    public static void loadDimensionDataMap(@Nullable NBTTagCompound compound) {
        usedDimensionIds.clear();
        lastUsedDimensionId = 0;
        if (compound == null) {
            IntIterator iterator = dimensionTypeByDimensionId.keySet().iterator();
            while (iterator.hasNext()) {
                int dimensionId = iterator.nextInt();
                if (dimensionId < 0) continue;
                usedDimensionIds.add(dimensionId);
            }
        } else {
            for (int id : compound.func_74759_k("UsedIDs")) {
                usedDimensionIds.add(id);
            }
            int[] intArray = compound.func_74759_k("DimensionArray");
            for (int i = 0; i < intArray.length; ++i) {
                int data = intArray[i];
                if (data == 0) continue;
                for (int j = 0; j < 32; ++j) {
                    if ((data & 1 << j) == 0) continue;
                    usedDimensionIds.add(i * 32 + j);
                }
            }
        }
    }

    public static NBTTagCompound saveDimensionDataMap() {
        NBTTagCompound dimMap = new NBTTagCompound();
        dimMap.func_74783_a("UsedIDs", usedDimensionIds.toIntArray());
        return dimMap;
    }

    public static Optional<Path> getCurrentSavesDirectory() {
        Optional<WorldServer> optWorldServer = WorldManager.getWorldByDimensionId(0);
        if (optWorldServer.isPresent()) {
            return Optional.of(optWorldServer.get().func_72860_G().func_75765_b().toPath());
        }
        if (SpongeImpl.getGame().getState().ordinal() >= GameState.SERVER_ABOUT_TO_START.ordinal()) {
            MinecraftServer server = SpongeImpl.getServer();
            return Optional.of(((MinecraftServerAccessor)((Object)server)).accessor$getAnvilFile().toPath().resolve(server.func_71270_I()));
        }
        return Optional.empty();
    }

    public static Map<WorldServer, WorldServer> getWeakWorldMap() {
        return weakWorldByWorld;
    }

    public static int getClientDimensionId(EntityPlayerMP player, net.minecraft.world.World world) {
        DimensionType type = world.field_73011_w.func_186058_p();
        if (type == DimensionType.OVERWORLD) {
            return 0;
        }
        if (type == DimensionType.NETHER) {
            return -1;
        }
        if (type == DimensionType.THE_END) {
            return 1;
        }
        return ((WorldServerBridge)world).bridge$getDimensionId();
    }

    public static boolean isKnownWorld(WorldServer world) {
        return weakWorldByWorld.containsKey(world);
    }

    private static class DeleteWorldTask
    implements Callable<Boolean> {
        private final WorldProperties props;

        DeleteWorldTask(WorldProperties props) {
            this.props = props;
        }

        @Override
        public Boolean call() {
            Path worldFolder = WorldManager.getCurrentSavesDirectory().get().resolve(this.props.getWorldName());
            if (!Files.exists(worldFolder, new LinkOption[0])) {
                WorldManager.unregisterWorldProperties(this.props, true);
                return true;
            }
            try {
                Files.walkFileTree(worldFolder, DeleteFileVisitor.INSTANCE);
                WorldManager.unregisterWorldProperties(this.props, true);
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
    }

    private static class CopyWorldTask
    implements Callable<Optional<WorldProperties>> {
        private final WorldInfo oldInfo;
        private final String newName;

        CopyWorldTask(WorldInfo info, String newName) {
            this.oldInfo = info;
            this.newName = newName;
        }

        @Override
        public Optional<WorldProperties> call() throws Exception {
            Path oldWorldFolder = WorldManager.getCurrentSavesDirectory().get().resolve(this.oldInfo.func_76065_j());
            Path newWorldFolder = WorldManager.getCurrentSavesDirectory().get().resolve(this.newName);
            if (Files.exists(newWorldFolder, new LinkOption[0])) {
                return Optional.empty();
            }
            FileVisitor<Path> visitor = new CopyFileVisitor(newWorldFolder, new CopyOption[0]);
            if (((WorldInfoBridge)this.oldInfo).bridge$getDimensionId() == 0) {
                oldWorldFolder = WorldManager.getCurrentSavesDirectory().get();
                visitor = new ForwardingFileVisitor<Path>((FileVisitor)visitor){
                    private boolean root;
                    {
                        super(x0);
                        this.root = true;
                    }

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        if (!this.root && Files.exists(dir.resolve("level.dat"), new LinkOption[0])) {
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        this.root = false;
                        return super.preVisitDirectory(dir, attrs);
                    }
                };
            }
            Files.walkFileTree(oldWorldFolder, visitor);
            WorldInfo info = new WorldInfo(this.oldInfo);
            info.func_76062_a(this.newName);
            ((WorldInfoBridge)info).bridge$setDimensionId(WorldManager.getNextFreeDimensionId());
            ((WorldInfoBridge)info).bridge$setUniqueId(UUID.randomUUID());
            ((WorldInfoBridge)info).bridge$createWorldConfig();
            new AnvilSaveHandler(WorldManager.getCurrentSavesDirectory().get().toFile(), this.newName, true, ((MinecraftServerAccessor)((Object)SpongeImpl.getServer())).accessor$getDataFixer()).func_75761_a(info);
            WorldManager.registerWorldProperties((WorldProperties)info);
            return Optional.of((WorldProperties)info);
        }
    }
}

