/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.biome;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.spongepowered.api.world.biome.BiomeGenerationSettings;
import org.spongepowered.api.world.biome.GroundCoverLayer;
import org.spongepowered.api.world.gen.GenerationPopulator;
import org.spongepowered.api.world.gen.Populator;
import org.spongepowered.common.world.biome.SpongeBiomeGenerationSettings;

public class SpongeBiomeGenerationSettingsBuilder
implements BiomeGenerationSettings.Builder {
    private float min = 0.0f;
    private float max = 0.0f;
    private final List<GroundCoverLayer> groundCover = Lists.newArrayList();
    private final List<Populator> populators = Lists.newArrayList();
    private final List<GenerationPopulator> genpop = Lists.newArrayList();

    @Override
    public BiomeGenerationSettings.Builder from(BiomeGenerationSettings value) {
        this.min = value.getMinHeight();
        this.max = value.getMaxHeight();
        this.groundCover.clear();
        this.groundCover.addAll(value.getGroundCoverLayers());
        this.genpop.clear();
        this.genpop.addAll(value.getGenerationPopulators());
        this.populators.clear();
        this.populators.addAll(value.getPopulators());
        return this;
    }

    @Override
    public BiomeGenerationSettings.Builder reset() {
        this.min = 0.0f;
        this.max = 0.0f;
        this.groundCover.clear();
        this.populators.clear();
        this.genpop.clear();
        return this;
    }

    @Override
    public BiomeGenerationSettings.Builder minHeight(float height) {
        this.min = height;
        return this;
    }

    @Override
    public BiomeGenerationSettings.Builder maxHeight(float height) {
        this.max = height;
        return this;
    }

    @Override
    public BiomeGenerationSettings.Builder groundCover(GroundCoverLayer ... coverLayers) {
        Preconditions.checkNotNull(coverLayers, "coverLayers");
        this.groundCover.clear();
        for (GroundCoverLayer layer : coverLayers) {
            this.groundCover.add(Preconditions.checkNotNull(layer, "layer"));
        }
        return this;
    }

    @Override
    public BiomeGenerationSettings.Builder groundCover(Iterable<GroundCoverLayer> coverLayers) {
        Preconditions.checkNotNull(coverLayers, "coverLayers");
        this.groundCover.clear();
        for (GroundCoverLayer layer : coverLayers) {
            this.groundCover.add(Preconditions.checkNotNull(layer, "layer"));
        }
        return this;
    }

    @Override
    public BiomeGenerationSettings.Builder generationPopulators(GenerationPopulator ... genpop) {
        Preconditions.checkNotNull(genpop, "genpop");
        this.genpop.clear();
        for (GenerationPopulator pop : genpop) {
            this.genpop.add(Preconditions.checkNotNull(pop, "pop"));
        }
        return this;
    }

    @Override
    public BiomeGenerationSettings.Builder generationPopulators(Iterable<GenerationPopulator> genpop) {
        Preconditions.checkNotNull(genpop, "genpop");
        this.genpop.clear();
        for (GenerationPopulator pop : genpop) {
            this.genpop.add(Preconditions.checkNotNull(pop, "pop"));
        }
        return this;
    }

    @Override
    public BiomeGenerationSettings.Builder populators(Populator ... populators) {
        Preconditions.checkNotNull(populators, "populators");
        this.populators.clear();
        for (Populator pop : populators) {
            this.populators.add(Preconditions.checkNotNull(pop, "pop"));
        }
        return this;
    }

    @Override
    public BiomeGenerationSettings.Builder populators(Iterable<Populator> populators) {
        Preconditions.checkNotNull(populators, "populators");
        this.populators.clear();
        for (Populator pop : populators) {
            this.populators.add(Preconditions.checkNotNull(pop, "pop"));
        }
        return this;
    }

    @Override
    public BiomeGenerationSettings build() throws IllegalStateException {
        SpongeBiomeGenerationSettings settings = new SpongeBiomeGenerationSettings();
        settings.setMinHeight(this.min);
        settings.setMaxHeight(this.max);
        settings.getGroundCoverLayers().addAll(this.groundCover);
        settings.getPopulators().addAll(this.populators);
        settings.getGenerationPopulators().addAll(this.genpop);
        return settings;
    }
}

