/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.biome;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.function.Function;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.biome.BiomeGenerationSettings;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.biome.VirtualBiomeType;

public class SpongeVirtualBiomeType
implements VirtualBiomeType {
    private final String id;
    private final String name;
    private final double tempterature;
    private final double humidity;
    private final BiomeType persisted;
    private final Function<World, BiomeGenerationSettings> defaultSettings;

    public SpongeVirtualBiomeType(String id, String name, double t, double h, BiomeType persist, Function<World, BiomeGenerationSettings> func) {
        this.id = Preconditions.checkNotNull(id);
        this.name = Preconditions.checkNotNull(name);
        this.tempterature = t;
        this.humidity = h;
        this.persisted = Preconditions.checkNotNull(persist);
        this.defaultSettings = func;
    }

    @Override
    public double getTemperature() {
        return this.tempterature;
    }

    @Override
    public double getHumidity() {
        return this.humidity;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public BiomeType getPersistedType() {
        return this.persisted;
    }

    @Override
    public BiomeGenerationSettings createDefaultGenerationSettings(World world) {
        return this.defaultSettings.apply(world);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VirtualBiomeType)) {
            return false;
        }
        return this.id == ((VirtualBiomeType)o).getId();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).add("name", this.name).add("persistedBiome", this.persisted).toString();
    }
}

