/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.extent;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import org.spongepowered.api.world.extent.ArchetypeVolume;
import org.spongepowered.api.world.extent.ExtentBufferFactory;
import org.spongepowered.api.world.extent.MutableBiomeVolume;
import org.spongepowered.api.world.extent.MutableBlockVolume;
import org.spongepowered.common.util.gen.ArrayMutableBlockBuffer;
import org.spongepowered.common.util.gen.ByteArrayMutableBiomeBuffer;
import org.spongepowered.common.world.schematic.GlobalPalette;
import org.spongepowered.common.world.schematic.SpongeArchetypeVolume;

public final class SpongeExtentBufferFactory
implements ExtentBufferFactory {
    public static final SpongeExtentBufferFactory INSTANCE = new SpongeExtentBufferFactory();

    private SpongeExtentBufferFactory() {
    }

    @Override
    public MutableBiomeVolume createBiomeBuffer(Vector3i min, Vector3i size) {
        return new ByteArrayMutableBiomeBuffer(GlobalPalette.getBiomePalette(), min, size);
    }

    @Override
    public MutableBiomeVolume createThreadSafeBiomeBuffer(Vector3i min, Vector3i size) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MutableBlockVolume createBlockBuffer(Vector3i min, Vector3i size) {
        return new ArrayMutableBlockBuffer(min, size);
    }

    @Override
    public MutableBlockVolume createThreadSafeBlockBuffer(Vector3i min, Vector3i size) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArchetypeVolume createArchetypeVolume(Vector3i size, Vector3i origin) {
        ArrayMutableBlockBuffer backing = new ArrayMutableBlockBuffer(origin.mul(-1), size);
        return new SpongeArchetypeVolume(backing, ImmutableMap.of(), Collections.emptyList());
    }
}

