/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.layer.IntCache;
import org.spongepowered.api.world.gen.BiomeGenerator;
import org.spongepowered.common.util.gen.ObjectArrayMutableBiomeBuffer;

public final class CustomBiomeProvider
extends BiomeProvider {
    private static final Vector3i CACHED_AREA_SIZE = new Vector3i(40, 1, 40);
    private final ObjectArrayMutableBiomeBuffer areaForGeneration = new ObjectArrayMutableBiomeBuffer(Vector3i.ZERO, CACHED_AREA_SIZE);
    private final BiomeGenerator biomeGenerator;

    public static BiomeProvider of(BiomeGenerator biomeGenerator) {
        if (biomeGenerator instanceof BiomeProvider) {
            return (BiomeProvider)biomeGenerator;
        }
        return new CustomBiomeProvider(biomeGenerator);
    }

    private CustomBiomeProvider(BiomeGenerator biomeGenerator) {
        this.biomeGenerator = Preconditions.checkNotNull(biomeGenerator, "biomeGenerator");
    }

    public BiomeGenerator getBiomeGenerator() {
        return this.biomeGenerator;
    }

    public Biome[] func_76931_a(Biome[] listToReuse, int x, int z, int width, int length, boolean cacheFlag) {
        return this.func_76933_b(listToReuse, x, z, width, length);
    }

    public Biome[] func_76937_a(Biome[] biomeArrayZoomedOut, int xStart, int zStart, int xSize, int zSize) {
        if (biomeArrayZoomedOut == null || biomeArrayZoomedOut.length < xSize * zSize) {
            biomeArrayZoomedOut = new Biome[xSize * zSize];
        }
        int xStartBlock = (xStart + 2) * 4;
        int zStartBlock = (zStart + 2) * 4;
        int xSizeBlock = xSize * 4;
        int zSizeBlock = zSize * 4;
        ObjectArrayMutableBiomeBuffer buffer = this.getBiomeBuffer(xStartBlock, zStartBlock, xSizeBlock, zSizeBlock);
        this.biomeGenerator.generateBiomes(buffer);
        for (int i = 0; i < biomeArrayZoomedOut.length; ++i) {
            Biome type;
            int x = i % xSize;
            int z = i / xSize;
            biomeArrayZoomedOut[i] = type = buffer.getNativeBiome(x * 4, 0, z * 4);
        }
        return biomeArrayZoomedOut;
    }

    private ObjectArrayMutableBiomeBuffer getBiomeBuffer(int xStart, int zStart, int xSize, int zSize) {
        if (xSize == CACHED_AREA_SIZE.getX() && zSize == CACHED_AREA_SIZE.getY()) {
            this.areaForGeneration.reuse(new Vector3i(xStart, 0, zStart));
            return this.areaForGeneration;
        }
        return new ObjectArrayMutableBiomeBuffer(new Vector3i(xStart, 0, zStart), new Vector3i(xSize, 1, zSize));
    }

    public boolean func_76940_a(int xCenter, int zCenter, int range, List searchingForBiomes) {
        IntCache.func_76446_a();
        int xStartSegment = xCenter - range;
        int zStartSegment = zCenter - range;
        int xMaxSegment = xCenter + range;
        int zMaxSegment = zCenter + range;
        int xSizeSegments = xMaxSegment - xStartSegment + 1;
        int zSizeSegments = zMaxSegment - zStartSegment + 1;
        ObjectArrayMutableBiomeBuffer buffer = this.getBiomeBuffer(xStartSegment, zStartSegment, xSizeSegments, zSizeSegments);
        this.biomeGenerator.generateBiomes(buffer);
        for (int x = xStartSegment; x < xMaxSegment; ++x) {
            for (int z = zStartSegment; z < zMaxSegment; ++z) {
                Biome type = buffer.getNativeBiome(x, 0, z);
                if (searchingForBiomes.contains(type)) continue;
                return false;
            }
        }
        return true;
    }

    public BlockPos func_180630_a(int xCenter, int zCenter, int range, List<Biome> biomes, Random random) {
        IntCache.func_76446_a();
        int xStartSegment = xCenter - range;
        int zStartSegment = zCenter - range;
        int xMaxSegment = xCenter + range;
        int zMaxSegment = zCenter + range;
        int xSizeSegments = xMaxSegment - xStartSegment + 1;
        int zSizeSegments = zMaxSegment - zStartSegment + 1;
        ObjectArrayMutableBiomeBuffer buffer = this.getBiomeBuffer(xStartSegment, zStartSegment, xSizeSegments, zSizeSegments);
        this.biomeGenerator.generateBiomes(buffer);
        BlockPos blockpos = null;
        int attempts = 0;
        for (int x = xStartSegment; x < xMaxSegment; ++x) {
            for (int z = zStartSegment; z < zMaxSegment; ++z) {
                Biome type = buffer.getNativeBiome(x, 0, z);
                if (!biomes.contains(type) || blockpos != null && random.nextInt(attempts + 1) != 0) continue;
                blockpos = new BlockPos(x, 0, z);
                ++attempts;
            }
        }
        return blockpos;
    }

    public Biome[] func_76933_b(Biome[] biomeArray, int startX, int startZ, int sizeX, int sizeZ) {
        if (biomeArray == null || biomeArray.length < sizeX * sizeZ) {
            biomeArray = new Biome[sizeX * sizeZ];
        } else {
            Arrays.fill(biomeArray, Biomes.field_76771_b);
        }
        ObjectArrayMutableBiomeBuffer biomeArea = new ObjectArrayMutableBiomeBuffer(new Vector3i(startX, 0, startZ), new Vector3i(sizeX, 1, sizeZ));
        this.biomeGenerator.generateBiomes(biomeArea);
        biomeArea.fill(biomeArray);
        return biomeArray;
    }
}

