/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen;

import co.aikar.timings.Timing;
import co.aikar.timings.Timings;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.structure.MapGenEndCity;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenNetherBridge;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureOceanMonument;
import net.minecraft.world.gen.structure.WoodlandMansion;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.world.chunk.PopulateChunkEvent;
import org.spongepowered.api.world.Chunk;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.biome.BiomeGenerationSettings;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.biome.GroundCoverLayer;
import org.spongepowered.api.world.extent.ImmutableBiomeVolume;
import org.spongepowered.api.world.gen.BiomeGenerator;
import org.spongepowered.api.world.gen.GenerationPopulator;
import org.spongepowered.api.world.gen.Populator;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.WorldGenerator;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.TimingBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.bridge.world.gen.ChunkGeneratorOverworldBridge;
import org.spongepowered.common.bridge.world.gen.FlaggedPopulatorBridge;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.generation.GenerationContext;
import org.spongepowered.common.event.tracking.phase.generation.GenerationPhase;
import org.spongepowered.common.event.tracking.phase.generation.PopulatorPhaseContext;
import org.spongepowered.common.mixin.core.world.WorldProviderAccessor;
import org.spongepowered.common.relocate.co.aikar.timings.SpongeTimingsFactory;
import org.spongepowered.common.util.gen.ChunkPrimerBuffer;
import org.spongepowered.common.util.gen.ObjectArrayMutableBiomeBuffer;
import org.spongepowered.common.world.biome.SpongeBiomeGenerationSettings;
import org.spongepowered.common.world.extent.SoftBufferExtentViewDownsize;
import org.spongepowered.common.world.gen.CustomBiomeProvider;
import org.spongepowered.common.world.gen.SpongeGenerationPopulator;
import org.spongepowered.common.world.gen.populators.SnowPopulator;

public class SpongeChunkGenerator
implements WorldGenerator,
IChunkGenerator {
    private static final Vector3i CHUNK_AREA = new Vector3i(16, 1, 16);
    protected BiomeGenerator biomeGenerator;
    protected GenerationPopulator baseGenerator;
    protected List<GenerationPopulator> genpop;
    protected List<Populator> pop;
    protected Map<BiomeType, BiomeGenerationSettings> biomeSettings;
    protected final net.minecraft.world.World world;
    protected final ObjectArrayMutableBiomeBuffer cachedBiomes;
    protected Random rand;
    private NoiseGeneratorPerlin noise4;
    private double[] stoneNoise;
    protected Map<String, Timing> populatorTimings = Maps.newHashMap();
    protected Timing chunkGeneratorTiming;

    public SpongeChunkGenerator(net.minecraft.world.World world, GenerationPopulator base, BiomeGenerator biomegen) {
        this.world = Preconditions.checkNotNull(world, "world");
        this.baseGenerator = Preconditions.checkNotNull(base, "baseGenerator");
        this.biomeGenerator = Preconditions.checkNotNull(biomegen, "biomeGenerator");
        this.cachedBiomes = new ObjectArrayMutableBiomeBuffer(Vector3i.ZERO, CHUNK_AREA);
        this.genpop = Lists.newArrayList();
        this.pop = Lists.newArrayList();
        this.biomeSettings = Maps.newHashMap();
        this.rand = new Random(world.func_72905_C());
        this.noise4 = new NoiseGeneratorPerlin(this.rand, 4);
        this.stoneNoise = new double[256];
        ((WorldProviderAccessor)this.world.field_73011_w).accessor$setBiomeProvider(CustomBiomeProvider.of(this.biomeGenerator));
        if (this.baseGenerator instanceof ChunkGeneratorOverworldBridge) {
            ((ChunkGeneratorOverworldBridge)((Object)this.baseGenerator)).bridge$setBiomeGenerator(this.biomeGenerator);
        }
        if (!this.getClass().getSimpleName().equalsIgnoreCase("SpongeChunkProviderForge")) {
            String chunkGeneratorName = "";
            chunkGeneratorName = base instanceof SpongeGenerationPopulator ? "chunkGenerator (" + ((SpongeGenerationPopulator)base).getHandle(world).getClass().getSimpleName() + ")" : "chunkGenerator (" + base.getClass().getName() + ")";
            this.chunkGeneratorTiming = SpongeTimingsFactory.ofSafe(chunkGeneratorName, ((WorldServerBridge)world).bridge$getTimingsHandler().chunkPopulate);
        }
    }

    @Override
    public GenerationPopulator getBaseGenerationPopulator() {
        return this.baseGenerator;
    }

    @Override
    public void setBaseGenerationPopulator(GenerationPopulator baseGenerationPopulator) {
        this.baseGenerator = baseGenerationPopulator;
        if (this.baseGenerator instanceof ChunkGeneratorOverworldBridge) {
            ((ChunkGeneratorOverworldBridge)((Object)this.baseGenerator)).bridge$setBiomeGenerator(this.biomeGenerator);
        }
    }

    @Override
    public List<GenerationPopulator> getGenerationPopulators() {
        return this.genpop;
    }

    public void setGenerationPopulators(List<GenerationPopulator> generationPopulators) {
        this.genpop = Lists.newArrayList(generationPopulators);
    }

    @Override
    public List<Populator> getPopulators() {
        return this.pop;
    }

    public void setPopulators(List<Populator> populators) {
        this.pop = Lists.newArrayList(populators);
    }

    public Map<BiomeType, BiomeGenerationSettings> getBiomeOverrides() {
        return this.biomeSettings;
    }

    public void setBiomeOverrides(Map<BiomeType, BiomeGenerationSettings> biomeOverrides) {
        this.biomeSettings = Maps.newHashMap(biomeOverrides);
    }

    @Override
    public BiomeGenerator getBiomeGenerator() {
        return this.biomeGenerator;
    }

    @Override
    public void setBiomeGenerator(BiomeGenerator biomeGenerator) {
        this.biomeGenerator = biomeGenerator;
        ((WorldProviderAccessor)this.world.field_73011_w).accessor$setBiomeProvider(CustomBiomeProvider.of(biomeGenerator));
        if (this.baseGenerator instanceof ChunkGeneratorOverworldBridge) {
            ((ChunkGeneratorOverworldBridge)((Object)this.baseGenerator)).bridge$setBiomeGenerator(biomeGenerator);
        }
    }

    @Override
    public BiomeGenerationSettings getBiomeSettings(BiomeType type) {
        Preconditions.checkNotNull(type, "type");
        BiomeGenerationSettings settings = this.biomeSettings.get(type);
        if (settings == null) {
            settings = SpongeGenerationPopulator.class.isInstance(this.baseGenerator) ? new SpongeBiomeGenerationSettings() : type.createDefaultGenerationSettings((World)this.world);
            this.biomeSettings.put(type, settings);
        }
        return settings;
    }

    @Override
    public List<GenerationPopulator> getGenerationPopulators(Class<? extends GenerationPopulator> type) {
        return this.genpop.stream().filter(p -> type.isAssignableFrom(p.getClass())).collect(Collectors.toList());
    }

    @Override
    public List<Populator> getPopulators(Class<? extends Populator> type) {
        return this.pop.stream().filter(p -> type.isAssignableFrom(p.getClass())).collect(Collectors.toList());
    }

    public net.minecraft.world.chunk.Chunk func_185932_a(int chunkX, int chunkZ) {
        net.minecraft.world.chunk.Chunk chunk;
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        this.cachedBiomes.reuse(new Vector3i(chunkX * 16, 0, chunkZ * 16));
        this.biomeGenerator.generateBiomes(this.cachedBiomes);
        ImmutableBiomeVolume biomeBuffer = this.cachedBiomes.getImmutableBiomeCopy();
        ChunkPrimer chunkprimer = new ChunkPrimer();
        ChunkPrimerBuffer blockBuffer = new ChunkPrimerBuffer(chunkprimer, chunkX, chunkZ);
        this.baseGenerator.populate((World)this.world, blockBuffer, biomeBuffer);
        if (!(this.baseGenerator instanceof SpongeGenerationPopulator)) {
            this.replaceBiomeBlocks(this.world, this.rand, chunkX, chunkZ, chunkprimer, biomeBuffer);
        }
        for (GenerationPopulator populator : this.genpop) {
            populator.populate((World)this.world, blockBuffer, biomeBuffer);
        }
        ArrayList<BiomeType> uniqueBiomes = Lists.newArrayList();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                BiomeType biome = this.cachedBiomes.getBiome(chunkX * 16 + x, 0, chunkZ * 16 + z);
                if (uniqueBiomes.contains(biome)) continue;
                uniqueBiomes.add(biome);
            }
        }
        for (BiomeType type : uniqueBiomes) {
            BiomeGenerationSettings settings = this.getBiomeSettings(type);
            for (GenerationPopulator populator : settings.getGenerationPopulators()) {
                populator.populate((World)this.world, blockBuffer, biomeBuffer);
            }
        }
        if (this.baseGenerator instanceof SpongeGenerationPopulator && ((SpongeGenerationPopulator)this.baseGenerator).getCachedChunk() != null) {
            chunk = ((SpongeGenerationPopulator)this.baseGenerator).getCachedChunk();
            ((ChunkBridge)chunk).bridge$fill(chunkprimer);
        } else {
            chunk = new net.minecraft.world.chunk.Chunk(this.world, chunkprimer, chunkX, chunkZ);
            this.cachedBiomes.fill(chunk.func_76605_m());
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        WorldServerBridge world = (WorldServerBridge)this.world;
        world.bridge$getTimingsHandler().chunkPopulate.startTimingIfSync();
        this.chunkGeneratorTiming.startTimingIfSync();
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        this.rand.setSeed(this.world.func_72905_C());
        long i1 = this.rand.nextLong() / 2L * 2L + 1L;
        long j1 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkX * i1 + (long)chunkZ * j1 ^ this.world.func_72905_C());
        BlockFalling.field_149832_M = true;
        this.cachedBiomes.reuse(new Vector3i(chunkX * 16, 0, chunkZ * 16));
        this.biomeGenerator.generateBiomes(this.cachedBiomes);
        ImmutableBiomeVolume biomeBuffer = this.cachedBiomes.getImmutableBiomeCopy();
        BlockPos blockpos = new BlockPos(chunkX * 16, 0, chunkZ * 16);
        BiomeType biome = (BiomeType)this.world.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        Chunk chunk = (Chunk)this.world.func_72964_e(chunkX, chunkZ);
        BiomeGenerationSettings settings = this.getBiomeSettings(biome);
        ArrayList<Populator> populators = new ArrayList<Populator>(this.pop);
        Populator snowPopulator = null;
        Iterator itr = populators.iterator();
        while (itr.hasNext()) {
            Populator populator = (Populator)itr.next();
            if (!(populator instanceof SnowPopulator)) continue;
            itr.remove();
            snowPopulator = populator;
            break;
        }
        populators.addAll(settings.getPopulators());
        if (snowPopulator != null) {
            populators.add(snowPopulator);
        }
        Sponge.getGame().getEventManager().post(SpongeEventFactory.createPopulateChunkEventPre(Sponge.getCauseStackManager().getCurrentCause(), populators, chunk));
        ArrayList<String> flags = Lists.newArrayList();
        IPhaseState<?> currentState = phaseTracker.getCurrentState();
        Vector3i min = currentState.getChunkPopulatorOffset(chunk, chunkX, chunkZ);
        World spongeWorld = (World)this.world;
        SoftBufferExtentViewDownsize volume = new SoftBufferExtentViewDownsize(chunk.getWorld(), min, min.add(15, 255, 15), min.sub(8, 0, 8), min.add(23, 255, 23));
        for (Populator populator : populators) {
            PopulatorType type = populator.getType();
            if (Sponge.getGame().getEventManager().post(SpongeEventFactory.createPopulateChunkEventPopulate(Sponge.getCauseStackManager().getCurrentCause(), populator, chunk))) continue;
            CauseStackManager.StackFrame ignored = Sponge.getCauseStackManager().pushCauseFrame();
            Throwable throwable = null;
            try {
                Timing timing = null;
                ignored.pushCause(populator);
                if (Timings.isTimingsEnabled()) {
                    timing = this.populatorTimings.get(populator.getType().getId());
                    if (timing == null) {
                        timing = SpongeTimingsFactory.ofSafe("populate - " + populator.getType().getId());
                        this.populatorTimings.put(populator.getType().getId(), timing);
                    }
                    timing.startTimingIfSync();
                }
                PopulatorPhaseContext context = ((PopulatorPhaseContext)GenerationPhase.State.POPULATOR_RUNNING.createPhaseContext().world((net.minecraft.world.World)((WorldServer)world))).populator(type);
                Throwable throwable2 = null;
                try {
                    context.buildAndSwitch();
                    if (populator instanceof FlaggedPopulatorBridge) {
                        ((FlaggedPopulatorBridge)((Object)populator)).bridge$populate(spongeWorld, volume, this.rand, biomeBuffer, flags);
                    } else {
                        populator.populate(spongeWorld, volume, this.rand, biomeBuffer);
                    }
                    if (timing == null) continue;
                    timing.stopTimingIfSync();
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (context == null) continue;
                    if (throwable2 != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    context.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (ignored == null) continue;
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                ignored.close();
            }
        }
        if (this.baseGenerator instanceof SpongeGenerationPopulator) {
            Timing timing = null;
            if (Timings.isTimingsEnabled()) {
                TimingBridge spongePopulator = (TimingBridge)((Object)this.baseGenerator);
                timing = spongePopulator.bridge$getTimingsHandler();
                timing.startTimingIfSync();
            }
            ((SpongeGenerationPopulator)this.baseGenerator).getHandle(this.world).func_185931_b(chunkX, chunkZ);
            if (Timings.isTimingsEnabled()) {
                timing.stopTimingIfSync();
            }
        }
        PopulateChunkEvent.Post event = SpongeEventFactory.createPopulateChunkEventPost(Sponge.getCauseStackManager().getCurrentCause(), ImmutableList.copyOf(populators), chunk);
        SpongeImpl.postEvent(event);
        BlockFalling.field_149832_M = false;
        this.chunkGeneratorTiming.stopTimingIfSync();
        world.bridge$getTimingsHandler().chunkPopulate.stopTimingIfSync();
    }

    public boolean func_185933_a(net.minecraft.world.chunk.Chunk chunk, int chunkX, int chunkZ) {
        boolean flag = false;
        if (chunk.func_177416_w() < 3600L) {
            for (Populator populator : this.pop) {
                if (!(populator instanceof StructureOceanMonument)) continue;
                CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();
                Throwable throwable = null;
                try {
                    GenerationContext context = (GenerationContext)((PopulatorPhaseContext)GenerationPhase.State.POPULATOR_RUNNING.createPhaseContext().world(this.world)).populator(populator.getType()).buildAndSwitch();
                    Throwable throwable2 = null;
                    try {
                        flag |= ((StructureOceanMonument)populator).func_175794_a(this.world, this.rand, new ChunkPos(chunkX, chunkZ));
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (context == null) continue;
                        if (throwable2 != null) {
                            try {
                                context.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        context.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (frame == null) continue;
                    if (throwable != null) {
                        try {
                            frame.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    frame.close();
                }
            }
        }
        return flag;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        if (this.baseGenerator instanceof IChunkGenerator) {
            return ((IChunkGenerator)this.baseGenerator).func_177458_a(creatureType, pos);
        }
        if (this.baseGenerator instanceof SpongeGenerationPopulator) {
            return ((SpongeGenerationPopulator)this.baseGenerator).getChunkGenerator().func_177458_a(creatureType, pos);
        }
        Biome biome = this.world.func_180494_b(pos);
        return biome.func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(net.minecraft.world.World worldIn, String structureName, BlockPos position, boolean p_180513_4_) {
        Class<MapGenStronghold> target = null;
        switch (structureName) {
            case "Stronghold": {
                target = MapGenStronghold.class;
                break;
            }
            case "Mansion": {
                target = WoodlandMansion.class;
                break;
            }
            case "Monument": {
                target = StructureOceanMonument.class;
                break;
            }
            case "Village": {
                target = MapGenVillage.class;
                break;
            }
            case "Mineshaft": {
                target = MapGenMineshaft.class;
                break;
            }
            case "Temple": {
                target = MapGenScatteredFeature.class;
                break;
            }
            case "Fortress": {
                target = MapGenNetherBridge.class;
                break;
            }
            case "EndCity": {
                target = MapGenEndCity.class;
            }
        }
        if (target != null) {
            for (GenerationPopulator gen : this.genpop) {
                if (!target.isInstance(gen)) continue;
                return ((MapGenStructure)gen).func_180706_b(worldIn, position, p_180513_4_);
            }
        }
        if (this.baseGenerator instanceof SpongeGenerationPopulator) {
            return ((SpongeGenerationPopulator)this.baseGenerator).getHandle(this.world).func_180513_a(worldIn, structureName, position, p_180513_4_);
        }
        return null;
    }

    public boolean func_193414_a(net.minecraft.world.World worldIn, String structureName, BlockPos position) {
        Class<MapGenStronghold> target = null;
        switch (structureName) {
            case "Stronghold": {
                target = MapGenStronghold.class;
                break;
            }
            case "Mansion": {
                target = WoodlandMansion.class;
                break;
            }
            case "Monument": {
                target = StructureOceanMonument.class;
                break;
            }
            case "Village": {
                target = MapGenVillage.class;
                break;
            }
            case "Mineshaft": {
                target = MapGenMineshaft.class;
                break;
            }
            case "Temple": {
                target = MapGenScatteredFeature.class;
                break;
            }
            case "Fortress": {
                target = MapGenNetherBridge.class;
                break;
            }
            case "EndCity": {
                target = MapGenEndCity.class;
            }
        }
        if (target != null) {
            for (GenerationPopulator gen : this.genpop) {
                if (!target.isInstance(gen)) continue;
                return ((MapGenStructure)gen).func_175795_b(position);
            }
        }
        if (this.baseGenerator instanceof SpongeGenerationPopulator) {
            return ((SpongeGenerationPopulator)this.baseGenerator).getHandle(this.world).func_193414_a(worldIn, structureName, position);
        }
        return false;
    }

    public void func_180514_a(net.minecraft.world.chunk.Chunk chunkIn, int x, int z) {
        if (!this.world.func_72912_H().func_76089_r()) {
            return;
        }
        if (this.baseGenerator instanceof IChunkGenerator) {
            ((IChunkGenerator)this.baseGenerator).func_180514_a(chunkIn, x, z);
        }
        if (this.baseGenerator instanceof SpongeGenerationPopulator) {
            ((SpongeGenerationPopulator)this.baseGenerator).getHandle(this.world).func_180514_a(chunkIn, x, z);
        }
        for (GenerationPopulator populator : this.genpop) {
            if (!(populator instanceof MapGenStructure)) continue;
            ((MapGenStructure)populator).func_186125_a(chunkIn.func_177412_p(), x, z, null);
        }
    }

    public void replaceBiomeBlocks(net.minecraft.world.World world, Random rand, int x, int z, ChunkPrimer chunk, ImmutableBiomeVolume biomes) {
        double d0 = 0.03125;
        this.stoneNoise = this.noise4.func_151599_a(this.stoneNoise, (double)(x * 16), (double)(z * 16), 16, 16, d0 * 2.0, d0 * 2.0, 1.0);
        Vector3i min = biomes.getBiomeMin();
        for (int x0 = 0; x0 < 16; ++x0) {
            for (int z0 = 0; z0 < 16; ++z0) {
                BiomeType biomegenbase = biomes.getBiome(min.getX() + x0, 0, min.getZ() + z0);
                this.generateBiomeTerrain(world, rand, chunk, x * 16 + x0, z * 16 + z0, this.stoneNoise[x0 + z0 * 16], this.getBiomeSettings(biomegenbase).getGroundCoverLayers());
            }
        }
    }

    public void generateBiomeTerrain(net.minecraft.world.World worldIn, Random rand, ChunkPrimer chunk, int x, int z, double stoneNoise, List<GroundCoverLayer> groundcover) {
        if (groundcover.isEmpty()) {
            return;
        }
        int seaLevel = worldIn.func_181545_F();
        IBlockState currentPlacement = null;
        int layerProgress = -1;
        int relativeX = x & 0xF;
        int relativeZ = z & 0xF;
        int layerDepth = 0;
        for (int currentY = 255; currentY >= 0; --currentY) {
            GroundCoverLayer layer;
            IBlockState nextBlock = chunk.func_177856_a(relativeX, currentY, relativeZ);
            if (nextBlock.func_185904_a() == Material.field_151579_a) {
                layerProgress = -1;
                continue;
            }
            if (nextBlock.func_177230_c() != Blocks.field_150348_b) continue;
            if (layerProgress == -1) {
                if (groundcover.isEmpty()) {
                    layerProgress = 0;
                    continue;
                }
                layerDepth = 0;
                layer = groundcover.get(layerDepth);
                currentPlacement = (IBlockState)layer.getBlockState().apply(stoneNoise);
                layerProgress = layer.getDepth(currentY).getFlooredAmount(rand, stoneNoise);
                if (layerProgress <= 0) continue;
                if (currentY >= seaLevel - 1) {
                    chunk.func_177855_a(relativeX, currentY, relativeZ, currentPlacement);
                    if (++layerDepth >= groundcover.size()) continue;
                    layer = groundcover.get(layerDepth);
                    layerProgress = layer.getDepth(currentY - 1).getFlooredAmount(rand, stoneNoise);
                    currentPlacement = (IBlockState)layer.getBlockState().apply(stoneNoise);
                    continue;
                }
                if (currentY < seaLevel - 7 - layerProgress) {
                    layerProgress = 0;
                    chunk.func_177855_a(relativeX, currentY, relativeZ, Blocks.field_150351_n.func_176223_P());
                    continue;
                }
                if (++layerDepth >= groundcover.size()) continue;
                layer = groundcover.get(layerDepth);
                layerProgress = layer.getDepth(currentY).getFlooredAmount(rand, stoneNoise);
                currentPlacement = (IBlockState)layer.getBlockState().apply(stoneNoise);
                chunk.func_177855_a(relativeX, currentY, relativeZ, currentPlacement);
                continue;
            }
            if (layerProgress <= 0) continue;
            chunk.func_177855_a(relativeX, currentY, relativeZ, currentPlacement);
            if (--layerProgress != 0 || ++layerDepth >= groundcover.size()) continue;
            layer = groundcover.get(layerDepth);
            layerProgress = layer.getDepth(currentY - 1).getFlooredAmount(rand, stoneNoise);
            currentPlacement = (IBlockState)layer.getBlockState().apply(stoneNoise);
        }
    }
}

