/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.world.World;
import org.spongepowered.api.world.biome.BiomeGenerationSettings;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.gen.BiomeGenerator;
import org.spongepowered.api.world.gen.GenerationPopulator;
import org.spongepowered.api.world.gen.Populator;
import org.spongepowered.api.world.gen.WorldGenerator;
import org.spongepowered.common.bridge.world.gen.ChunkGeneratorOverworldBridge;
import org.spongepowered.common.mixin.core.world.WorldProviderAccessor;
import org.spongepowered.common.world.biome.SpongeBiomeGenerationSettings;
import org.spongepowered.common.world.gen.CustomBiomeProvider;
import org.spongepowered.common.world.gen.SpongeGenerationPopulator;

public final class SpongeWorldGenerator
implements WorldGenerator {
    private final World world;
    private List<Populator> populators;
    private List<GenerationPopulator> generationPopulators;
    private Map<BiomeType, BiomeGenerationSettings> biomeSettings;
    private BiomeGenerator biomeGenerator;
    private GenerationPopulator baseGenerator;

    public SpongeWorldGenerator(World world, BiomeGenerator biomeGenerator, GenerationPopulator baseGenerator) {
        this.world = Preconditions.checkNotNull(world);
        this.biomeGenerator = Preconditions.checkNotNull(biomeGenerator);
        this.baseGenerator = Preconditions.checkNotNull(baseGenerator);
        this.populators = Lists.newArrayList();
        this.generationPopulators = Lists.newArrayList();
        this.biomeSettings = Maps.newHashMap();
        ((WorldProviderAccessor)this.world.field_73011_w).accessor$setBiomeProvider(CustomBiomeProvider.of(biomeGenerator));
        if (this.baseGenerator instanceof ChunkGeneratorOverworldBridge) {
            ((ChunkGeneratorOverworldBridge)((Object)this.baseGenerator)).bridge$setBiomeGenerator(biomeGenerator);
        }
    }

    @Override
    public List<GenerationPopulator> getGenerationPopulators() {
        return this.generationPopulators;
    }

    @Override
    public List<GenerationPopulator> getGenerationPopulators(Class<? extends GenerationPopulator> type) {
        return this.generationPopulators.stream().filter(p -> type.isAssignableFrom(p.getClass())).collect(Collectors.toList());
    }

    @Override
    public List<Populator> getPopulators() {
        return this.populators;
    }

    @Override
    public List<Populator> getPopulators(Class<? extends Populator> type) {
        return this.populators.stream().filter(p -> type.isAssignableFrom(p.getClass())).collect(Collectors.toList());
    }

    @Override
    public BiomeGenerator getBiomeGenerator() {
        return this.biomeGenerator;
    }

    @Override
    public void setBiomeGenerator(BiomeGenerator biomeGenerator) {
        this.biomeGenerator = Preconditions.checkNotNull(biomeGenerator, "biomeGenerator");
        ((WorldProviderAccessor)this.world.field_73011_w).accessor$setBiomeProvider(CustomBiomeProvider.of(biomeGenerator));
        if (this.baseGenerator instanceof ChunkGeneratorOverworldBridge) {
            ((ChunkGeneratorOverworldBridge)((Object)this.baseGenerator)).bridge$setBiomeGenerator(biomeGenerator);
        }
    }

    @Override
    public GenerationPopulator getBaseGenerationPopulator() {
        return this.baseGenerator;
    }

    @Override
    public void setBaseGenerationPopulator(GenerationPopulator generator) {
        this.baseGenerator = Preconditions.checkNotNull(generator, "generator");
        if (this.baseGenerator instanceof ChunkGeneratorOverworldBridge) {
            ((ChunkGeneratorOverworldBridge)((Object)this.baseGenerator)).bridge$setBiomeGenerator(this.biomeGenerator);
        }
    }

    @Override
    public BiomeGenerationSettings getBiomeSettings(BiomeType type) {
        Preconditions.checkNotNull(type);
        BiomeGenerationSettings settings = this.biomeSettings.get(type);
        if (settings == null) {
            settings = SpongeGenerationPopulator.class.isInstance(this.baseGenerator) ? new SpongeBiomeGenerationSettings() : type.createDefaultGenerationSettings((org.spongepowered.api.world.World)this.world);
            this.biomeSettings.put(type, settings);
        }
        return settings;
    }

    public Map<BiomeType, BiomeGenerationSettings> getBiomeSettings() {
        return ImmutableMap.copyOf(this.biomeSettings);
    }
}

