/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.builders;

import com.google.common.base.Preconditions;
import net.minecraft.block.Block;
import net.minecraft.world.gen.feature.WorldGenBlockBlob;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.gen.populator.BlockBlob;

public class BlockBlobBuilder
implements BlockBlob.Builder {
    private BlockState block;
    private VariableAmount radius;
    private VariableAmount count;

    public BlockBlobBuilder() {
        this.reset();
    }

    @Override
    public BlockBlob.Builder block(BlockState block) {
        Preconditions.checkNotNull(block, "block");
        this.block = block;
        return this;
    }

    @Override
    public BlockBlob.Builder radius(VariableAmount radius) {
        Preconditions.checkNotNull(radius, "radius");
        this.radius = radius;
        return this;
    }

    @Override
    public BlockBlob.Builder blobCount(VariableAmount count) {
        Preconditions.checkNotNull(count, "count");
        this.count = count;
        return this;
    }

    @Override
    public BlockBlob.Builder from(BlockBlob value) {
        Preconditions.checkNotNull(value, "BlockBlob cannot be null!");
        this.block = Preconditions.checkNotNull(value.getBlock(), "BlockState cannot be null!");
        this.radius = Preconditions.checkNotNull(value.getRadius(), "Radius cannot be null!");
        this.count = Preconditions.checkNotNull(value.getCount(), "Count cannot be null!");
        return this;
    }

    @Override
    public BlockBlob.Builder reset() {
        this.radius = VariableAmount.baseWithVariance(0.0, 2.0);
        this.count = VariableAmount.baseWithVariance(0.0, 3.0);
        this.block = null;
        return this;
    }

    @Override
    public BlockBlob build() throws IllegalStateException {
        if (this.block == null) {
            throw new IllegalStateException("Builder is missing required BlockState argument.");
        }
        BlockBlob populator = (BlockBlob)new WorldGenBlockBlob((Block)this.block.getType(), 2);
        populator.setBlock(this.block);
        populator.setRadius(this.radius);
        populator.setCount(this.count);
        return populator;
    }
}

