/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.builders;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.world.gen.feature.WorldGenDoublePlant;
import org.spongepowered.api.data.type.DoublePlantType;
import org.spongepowered.api.util.weighted.TableEntry;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.util.weighted.WeightedObject;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.populator.DoublePlant;

public class DoublePlantBuilder
implements DoublePlant.Builder {
    private WeightedTable<DoublePlantType> types;
    @Nullable
    private Function<Location<Extent>, DoublePlantType> override;
    private VariableAmount count;

    public DoublePlantBuilder() {
        this.reset();
    }

    @Override
    public DoublePlant.Builder types(WeightedTable<DoublePlantType> types) {
        Preconditions.checkNotNull(types, "types");
        this.types = types;
        return this;
    }

    @Override
    public DoublePlant.Builder type(DoublePlantType type, double weight) {
        Preconditions.checkNotNull(type);
        this.types.add((TableEntry<DoublePlantType>)new WeightedObject<DoublePlantType>(type, weight));
        return this;
    }

    @Override
    public DoublePlant.Builder perChunk(VariableAmount count) {
        Preconditions.checkNotNull(count, "count");
        this.count = count;
        return this;
    }

    @Override
    public DoublePlant.Builder supplier(@Nullable Function<Location<Extent>, DoublePlantType> override) {
        this.override = override;
        return this;
    }

    @Override
    public DoublePlant.Builder from(DoublePlant value) {
        WeightedTable<DoublePlantType> table = new WeightedTable<DoublePlantType>();
        table.addAll((Collection<TableEntry<DoublePlantType>>)value.getPossibleTypes());
        this.types(table);
        this.perChunk(value.getPlantsPerChunk());
        this.supplier(value.getSupplierOverride().orElse(null));
        return this;
    }

    @Override
    public DoublePlant.Builder reset() {
        this.types = new WeightedTable();
        this.count = VariableAmount.fixed(1.0);
        this.override = null;
        return this;
    }

    @Override
    public DoublePlant build() throws IllegalStateException {
        if (this.types.isEmpty()) {
            throw new IllegalStateException("Builder is missing required weighted plant types.");
        }
        WorldGenDoublePlant wgen = new WorldGenDoublePlant();
        wgen.func_180710_a(BlockDoublePlant.EnumPlantType.GRASS);
        DoublePlant populator = (DoublePlant)wgen;
        populator.getPossibleTypes().addAll((Collection<TableEntry<DoublePlantType>>)this.types);
        populator.setPlantsPerChunk(this.count);
        populator.setSupplierOverride(this.override);
        return populator;
    }
}

