/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.builders;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import org.spongepowered.api.data.manipulator.mutable.MobSpawnerData;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.util.weighted.LootTable;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.api.world.gen.populator.Dungeon;

public class DungeonBuilder
implements Dungeon.Builder {
    private VariableAmount attempts;
    @Nullable
    private MobSpawnerData data;
    @Nullable
    private WeightedTable<EntityArchetype> choices;
    private LootTable<ItemStackSnapshot> items;

    public DungeonBuilder() {
        this.reset();
    }

    @Override
    public Dungeon.Builder attempts(VariableAmount attempts) {
        this.attempts = Preconditions.checkNotNull(attempts, "attempts");
        return this;
    }

    @Override
    public Dungeon.Builder mobSpawnerData(MobSpawnerData data) {
        this.data = Preconditions.checkNotNull(data, "data");
        this.choices = null;
        return this;
    }

    @Override
    public Dungeon.Builder choices(WeightedTable<EntityArchetype> choices) {
        this.choices = Preconditions.checkNotNull(choices, "choices");
        this.data = null;
        return this;
    }

    @Override
    public Dungeon.Builder possibleItems(LootTable<ItemStackSnapshot> items) {
        this.items = Preconditions.checkNotNull(items, "items");
        return this;
    }

    @Override
    public Dungeon.Builder from(Dungeon value) {
        this.attempts(value.getAttemptsPerChunk());
        value.getMobSpawnerData().ifPresent(this::mobSpawnerData);
        value.getChoices().ifPresent(this::choices);
        this.items = new LootTable();
        this.items.addAll(value.getPossibleContents());
        return this;
    }

    @Override
    public Dungeon.Builder reset() {
        this.attempts = VariableAmount.fixed(8.0);
        this.data = null;
        this.choices = null;
        this.items = new LootTable();
        return this;
    }

    @Override
    public Dungeon build() throws IllegalStateException {
        Dungeon populator = (Dungeon)new WorldGenDungeons();
        populator.setAttemptsPerChunk(this.attempts);
        if (this.data != null) {
            populator.setMobSpawnerData(this.data);
        }
        if (this.choices != null) {
            populator.setChoices(this.choices);
        }
        populator.getPossibleContents().clearPool();
        populator.getPossibleContents().addAll(this.items);
        return populator;
    }
}

