/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.builders;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFlower;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenFlowers;
import org.spongepowered.api.data.type.PlantType;
import org.spongepowered.api.util.weighted.TableEntry;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.util.weighted.WeightedObject;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.populator.Flower;

public class FlowerBuilder
implements Flower.Builder {
    private WeightedTable<PlantType> flowers;
    @Nullable
    private Function<Location<Extent>, PlantType> override;
    private VariableAmount count;

    public FlowerBuilder() {
        this.reset();
    }

    @Override
    public Flower.Builder perChunk(VariableAmount count) {
        Preconditions.checkNotNull(count);
        this.count = count;
        return this;
    }

    @Override
    public Flower.Builder types(WeightedTable<PlantType> types) {
        Preconditions.checkNotNull(types);
        this.flowers = types;
        return this;
    }

    @Override
    public Flower.Builder type(PlantType type, double weight) {
        Preconditions.checkNotNull(type);
        this.flowers.add((TableEntry<PlantType>)new WeightedObject<PlantType>(type, weight));
        return this;
    }

    @Override
    public Flower.Builder supplier(@Nullable Function<Location<Extent>, PlantType> override) {
        this.override = override;
        return this;
    }

    @Override
    public Flower.Builder from(Flower value) {
        WeightedTable<PlantType> table = new WeightedTable<PlantType>();
        table.addAll((Collection<TableEntry<PlantType>>)value.getFlowerTypes());
        return this.perChunk(value.getFlowersPerChunk()).types(table).supplier(value.getSupplierOverride().orElse(null));
    }

    @Override
    public Flower.Builder reset() {
        this.flowers = new WeightedTable();
        this.count = VariableAmount.fixed(2.0);
        this.override = null;
        return this;
    }

    @Override
    public Flower build() throws IllegalStateException {
        Flower populator = (Flower)new WorldGenFlowers(Blocks.field_150327_N, BlockFlower.EnumFlowerType.DANDELION);
        populator.setFlowersPerChunk(this.count);
        populator.getFlowerTypes().addAll((Collection<TableEntry<PlantType>>)this.flowers);
        populator.setSupplierOverride(this.override);
        return populator;
    }
}

