/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.builders;

import com.google.common.base.Preconditions;
import net.minecraft.world.gen.feature.WorldGenGlowStone1;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.gen.populator.Glowstone;

public class GlowstoneBuilder
implements Glowstone.Builder {
    private VariableAmount count;
    private VariableAmount attempts;
    private VariableAmount clusterheight;
    private VariableAmount height;

    public GlowstoneBuilder() {
        this.reset();
    }

    @Override
    public Glowstone.Builder perChunk(VariableAmount count) {
        this.count = Preconditions.checkNotNull(count, "count");
        return this;
    }

    @Override
    public Glowstone.Builder blocksPerCluster(VariableAmount attempts) {
        this.attempts = Preconditions.checkNotNull(attempts, "attempts");
        return this;
    }

    @Override
    public Glowstone.Builder clusterHeight(VariableAmount height) {
        this.clusterheight = Preconditions.checkNotNull(height, "clusterheight");
        return this;
    }

    @Override
    public Glowstone.Builder height(VariableAmount height) {
        this.height = Preconditions.checkNotNull(height, "height");
        return this;
    }

    @Override
    public Glowstone.Builder from(Glowstone value) {
        return this.perChunk(value.getClustersPerChunk()).blocksPerCluster(value.getAttemptsPerCluster()).clusterHeight(value.getClusterHeight()).height(value.getHeight());
    }

    @Override
    public Glowstone.Builder reset() {
        this.count = VariableAmount.baseWithRandomAddition(1.0, 10.0);
        this.attempts = VariableAmount.fixed(1500.0);
        this.clusterheight = VariableAmount.baseWithRandomAddition(0.0, 12.0);
        this.height = VariableAmount.baseWithRandomAddition(4.0, 120.0);
        return this;
    }

    @Override
    public Glowstone build() throws IllegalStateException {
        Glowstone pop = (Glowstone)new WorldGenGlowStone1();
        pop.setAttemptsPerCluster(this.attempts);
        pop.setClustersPerChunk(this.count);
        pop.setClusterHeight(this.clusterheight);
        pop.setHeight(this.height);
        return pop;
    }
}

