/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.builders;

import com.google.common.base.Preconditions;
import net.minecraft.world.gen.feature.WorldGenIceSpike;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.gen.populator.IceSpike;

public class IceSpikeBuilder
implements IceSpike.Builder {
    private VariableAmount height;
    private VariableAmount count;
    private double extremeChance;
    private VariableAmount extremeIncrease;

    public IceSpikeBuilder() {
        this.reset();
    }

    @Override
    public IceSpike.Builder height(VariableAmount height) {
        this.height = Preconditions.checkNotNull(height, "height");
        return this;
    }

    @Override
    public IceSpike.Builder spikesPerChunk(VariableAmount count) {
        this.count = Preconditions.checkNotNull(count, "count");
        return this;
    }

    @Override
    public IceSpike.Builder extremeSpikeProbability(double p) {
        Preconditions.checkArgument(!Double.isNaN(p), "The probability must be a number.");
        Preconditions.checkArgument(!Double.isInfinite(p), "The probability cannot be infinite.");
        this.extremeChance = p;
        return this;
    }

    @Override
    public IceSpike.Builder extremeSpikeIncrease(VariableAmount increase) {
        this.extremeIncrease = Preconditions.checkNotNull(increase, "increase");
        return this;
    }

    @Override
    public IceSpike.Builder from(IceSpike value) {
        return this.height(value.getHeight()).spikesPerChunk(value.getSpikesPerChunk()).extremeSpikeIncrease(value.getExtremeSpikeIncrease());
    }

    @Override
    public IceSpike.Builder reset() {
        this.height = VariableAmount.baseWithRandomAddition(7.0, 4.0);
        this.count = VariableAmount.fixed(3.0);
        this.extremeChance = 0.016666666666666666;
        this.extremeIncrease = VariableAmount.baseWithRandomAddition(10.0, 30.0);
        return this;
    }

    @Override
    public IceSpike build() throws IllegalStateException {
        IceSpike pop = (IceSpike)new WorldGenIceSpike();
        pop.setHeight(this.height);
        pop.setExtremeSpikeProbability(this.extremeChance);
        pop.setExtremeSpikeIncrease(this.extremeIncrease);
        pop.setSpikesPerChunk(this.count);
        return pop;
    }
}

