/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.builders;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.world.gen.feature.WorldGenLakes;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.property.block.MatterProperty;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.gen.populator.Lake;

public class LakeBuilder
implements Lake.Builder {
    private BlockState liquid;
    private double chance;
    private VariableAmount height;

    public LakeBuilder() {
        this.reset();
    }

    @Override
    public Lake.Builder liquidType(BlockState liquid) {
        this.liquid = Preconditions.checkNotNull(liquid, "liquid");
        Optional<MatterProperty> matter = liquid.getType().getProperty(MatterProperty.class);
        Preconditions.checkArgument(matter.isPresent(), "For some reason, the property is not returning correctly!");
        Preconditions.checkArgument(matter.get().getValue() == MatterProperty.Matter.LIQUID, "Must use a liquid property based BlockState!");
        return this;
    }

    @Override
    public Lake.Builder chance(double p) {
        Preconditions.checkArgument(!Double.isNaN(p), "The probability must be a number.");
        Preconditions.checkArgument(!Double.isInfinite(p), "The probability cannot be infinite.");
        this.chance = p;
        return this;
    }

    @Override
    public Lake.Builder height(VariableAmount height) {
        this.height = Preconditions.checkNotNull(height);
        return this;
    }

    @Override
    public Lake.Builder from(Lake value) {
        return this.liquidType(value.getLiquidType()).chance(value.getLakeProbability()).height(value.getHeight());
    }

    @Override
    public Lake.Builder reset() {
        this.liquid = BlockTypes.WATER.getDefaultState();
        this.chance = 0.05;
        this.height = VariableAmount.baseWithRandomAddition(0.0, 256.0);
        return this;
    }

    @Override
    public Lake build() throws IllegalStateException {
        Lake pop = (Lake)new WorldGenLakes((Block)this.liquid.getType());
        pop.setLiquidType(this.liquid);
        pop.setLakeProbability(this.chance);
        pop.setHeight(this.height);
        return pop;
    }
}

