/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.builders;

import com.google.common.base.Preconditions;
import net.minecraft.world.gen.feature.WorldGenFire;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.gen.populator.NetherFire;

public class NetherFireBuilder
implements NetherFire.Builder {
    private VariableAmount count;
    private VariableAmount cluster;

    public NetherFireBuilder() {
        this.reset();
    }

    @Override
    public NetherFire.Builder perChunk(VariableAmount count) {
        this.count = Preconditions.checkNotNull(count, "count");
        return this;
    }

    @Override
    public NetherFire.Builder perCluster(VariableAmount count) {
        this.cluster = Preconditions.checkNotNull(count, "cluster");
        return this;
    }

    @Override
    public NetherFire.Builder from(NetherFire value) {
        return this.perChunk(value.getClustersPerChunk()).perCluster(value.getFirePerCluster());
    }

    @Override
    public NetherFire.Builder reset() {
        this.cluster = VariableAmount.fixed(64.0);
        this.count = VariableAmount.baseWithRandomAddition(1.0, VariableAmount.baseWithRandomAddition(1.0, 10.0));
        return this;
    }

    @Override
    public NetherFire build() throws IllegalStateException {
        NetherFire pop = (NetherFire)new WorldGenFire();
        pop.setFirePerCluster(this.cluster);
        pop.setClustersPerChunk(this.count);
        return pop;
    }
}

