/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.builders;

import com.google.common.base.Preconditions;
import java.util.function.Predicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenMinable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.gen.populator.Ore;
import org.spongepowered.common.world.gen.WorldGenConstants;

public class OreBuilder
implements Ore.Builder {
    private BlockState block;
    private VariableAmount size;
    private VariableAmount count;
    private VariableAmount height;
    private Predicate<BlockState> conditions;

    public OreBuilder() {
        this.reset();
    }

    @Override
    public Ore.Builder ore(BlockState block) {
        this.block = Preconditions.checkNotNull(block, "block");
        return this;
    }

    @Override
    public Ore.Builder size(VariableAmount size) {
        this.size = Preconditions.checkNotNull(size, "size");
        return this;
    }

    @Override
    public Ore.Builder perChunk(VariableAmount count) {
        this.count = Preconditions.checkNotNull(count, "count");
        return this;
    }

    @Override
    public Ore.Builder height(VariableAmount height) {
        this.height = Preconditions.checkNotNull(height, "height");
        return this;
    }

    @Override
    public Ore.Builder placementCondition(Predicate<BlockState> condition) {
        this.conditions = Preconditions.checkNotNull(condition, "conditions");
        return this;
    }

    @Override
    public Ore.Builder from(Ore value) {
        return this.ore(value.getOreBlock()).size(value.getDepositSize()).perChunk(value.getDepositsPerChunk()).height(value.getHeight()).placementCondition(value.getPlacementCondition());
    }

    @Override
    public Ore.Builder reset() {
        this.block = (BlockState)Blocks.field_150366_p.func_176223_P();
        this.size = VariableAmount.fixed(9.0);
        this.count = VariableAmount.fixed(20.0);
        this.height = VariableAmount.baseWithRandomAddition(0.0, 64.0);
        this.conditions = WorldGenConstants.STONE;
        return this;
    }

    @Override
    public Ore build() throws IllegalStateException {
        Ore pop = (Ore)new WorldGenMinable((IBlockState)this.block, 10);
        pop.setDepositSize(this.size);
        pop.setDepositsPerChunk(this.count);
        pop.setHeight(this.height);
        pop.setOreBlock(this.block);
        pop.setPlacementCondition(this.conditions);
        return pop;
    }
}

