/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.builders;

import com.google.common.base.Preconditions;
import net.minecraft.world.gen.feature.WorldGenPumpkin;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.gen.populator.Pumpkin;

public class PumpkinBuilder
implements Pumpkin.Builder {
    private VariableAmount count;
    private double chance;

    public PumpkinBuilder() {
        this.reset();
    }

    @Override
    public Pumpkin.Builder perChunk(VariableAmount count) {
        this.count = Preconditions.checkNotNull(count, "count");
        return this;
    }

    @Override
    public Pumpkin.Builder chance(double p) {
        Preconditions.checkArgument(!Double.isNaN(p), "The probability must be a number.");
        Preconditions.checkArgument(!Double.isInfinite(p), "The probability cannot be infinite.");
        this.chance = p;
        return this;
    }

    @Override
    public Pumpkin.Builder from(Pumpkin value) {
        return this.perChunk(value.getPumpkinsPerChunk()).chance(value.getPumpkinChance());
    }

    @Override
    public Pumpkin.Builder reset() {
        this.chance = 0.03125;
        this.count = VariableAmount.fixed(64.0);
        return this;
    }

    @Override
    public Pumpkin build() throws IllegalStateException {
        Pumpkin pop = (Pumpkin)new WorldGenPumpkin();
        pop.setPumpkinChance(this.chance);
        pop.setPumpkinsPerChunk(this.count);
        return pop;
    }
}

