/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.builders;

import com.google.common.base.Preconditions;
import net.minecraft.world.gen.feature.WorldGenReed;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.gen.populator.Reed;

public class ReedBuilder
implements Reed.Builder {
    private VariableAmount count;
    private VariableAmount height;

    public ReedBuilder() {
        this.reset();
    }

    @Override
    public Reed.Builder perChunk(VariableAmount count) {
        this.count = Preconditions.checkNotNull(count, "count");
        return this;
    }

    @Override
    public Reed.Builder reedHeight(VariableAmount height) {
        this.height = Preconditions.checkNotNull(height, "height");
        return this;
    }

    @Override
    public Reed.Builder from(Reed value) {
        return this.perChunk(value.getReedsPerChunk()).reedHeight(value.getReedHeight());
    }

    @Override
    public Reed.Builder reset() {
        this.count = VariableAmount.fixed(20.0);
        this.height = VariableAmount.baseWithRandomAddition(2.0, VariableAmount.baseWithRandomAddition(1.0, 3.0));
        return this;
    }

    @Override
    public Reed build() throws IllegalStateException {
        Reed pop = (Reed)new WorldGenReed();
        pop.setReedHeight(this.height);
        pop.setReedsPerChunk(this.count);
        return pop;
    }
}

