/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.builders;

import com.google.common.base.Preconditions;
import java.util.function.Predicate;
import net.minecraft.init.Blocks;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.gen.populator.SeaFloor;
import org.spongepowered.common.world.gen.WorldGenConstants;
import org.spongepowered.common.world.gen.populators.SeaFloorPopulator;

public class SeaFloorBuilder
implements SeaFloor.Builder {
    private BlockState block;
    private VariableAmount count;
    private VariableAmount radius;
    private VariableAmount depth;
    private Predicate<BlockState> check;

    public SeaFloorBuilder() {
        this.reset();
    }

    @Override
    public SeaFloor.Builder block(BlockState block) {
        this.block = Preconditions.checkNotNull(block, "block");
        return this;
    }

    @Override
    public SeaFloor.Builder perChunk(VariableAmount count) {
        this.count = Preconditions.checkNotNull(count, "count");
        return this;
    }

    @Override
    public SeaFloor.Builder radius(VariableAmount radius) {
        this.radius = Preconditions.checkNotNull(radius, "radius");
        return this;
    }

    @Override
    public SeaFloor.Builder depth(VariableAmount depth) {
        this.depth = Preconditions.checkNotNull(depth, "depth");
        return this;
    }

    @Override
    public SeaFloor.Builder replace(Predicate<BlockState> check) {
        this.check = Preconditions.checkNotNull(check, "check");
        return this;
    }

    @Override
    public SeaFloor.Builder from(SeaFloor value) {
        this.block(value.getBlock()).perChunk(value.getDiscsPerChunk()).radius(value.getRadius()).depth(value.getDepth()).replace(value.getValidBlocksToReplace());
        return this;
    }

    @Override
    public SeaFloor.Builder reset() {
        this.check = WorldGenConstants.DIRT_OR_GRASS;
        this.block = (BlockState)Blocks.field_150354_m.func_176223_P();
        this.radius = VariableAmount.fixed(7.0);
        this.count = VariableAmount.fixed(3.0);
        this.depth = VariableAmount.fixed(2.0);
        return this;
    }

    @Override
    public SeaFloor build() throws IllegalStateException {
        SeaFloorPopulator pop = new SeaFloorPopulator(this.block, this.radius, this.count, this.depth, this.check);
        return pop;
    }
}

