/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.builders;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import org.spongepowered.api.data.type.ShrubType;
import org.spongepowered.api.util.weighted.TableEntry;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.util.weighted.WeightedObject;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.populator.Shrub;

public class ShrubBuilder
implements Shrub.Builder {
    private VariableAmount count;
    private WeightedTable<ShrubType> types;
    @Nullable
    private Function<Location<Extent>, ShrubType> override;

    public ShrubBuilder() {
        this.reset();
    }

    @Override
    public Shrub.Builder perChunk(VariableAmount count) {
        this.count = Preconditions.checkNotNull(count, "count");
        return this;
    }

    @Override
    public Shrub.Builder types(WeightedTable<ShrubType> types) {
        Preconditions.checkNotNull(types);
        this.types = types;
        return this;
    }

    @Override
    public Shrub.Builder type(ShrubType type, int weight) {
        Preconditions.checkNotNull(type);
        this.types.add((TableEntry<ShrubType>)new WeightedObject<ShrubType>(type, weight));
        return this;
    }

    @Override
    public Shrub.Builder supplier(@Nullable Function<Location<Extent>, ShrubType> override) {
        this.override = override;
        return this;
    }

    @Override
    public Shrub.Builder from(Shrub value) {
        WeightedTable<ShrubType> table = new WeightedTable<ShrubType>();
        table.addAll((Collection<TableEntry<ShrubType>>)value.getTypes());
        return this.perChunk(value.getShrubsPerChunk()).types(table).supplier(value.getSupplierOverride().orElse(null));
    }

    @Override
    public Shrub.Builder reset() {
        if (this.types == null) {
            this.types = new WeightedTable();
        } else {
            this.types.clear();
        }
        this.count = VariableAmount.fixed(128.0);
        this.override = null;
        return this;
    }

    @Override
    public Shrub build() throws IllegalStateException {
        Shrub pop = (Shrub)new WorldGenTallGrass(BlockTallGrass.EnumType.GRASS);
        pop.getTypes().clear();
        pop.getTypes().addAll((Collection<TableEntry<ShrubType>>)this.types);
        pop.setShrubsPerChunk(this.count);
        pop.setSupplierOverride(this.override);
        return pop;
    }
}

