/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.populators;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.util.weighted.WeightedTable;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorObject;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.PopulatorTypes;
import org.spongepowered.api.world.gen.populator.Forest;
import org.spongepowered.common.util.VecHelper;

public class ForestPopulator
implements Forest {
    private VariableAmount count = VariableAmount.fixed(10.0);
    private WeightedTable<PopulatorObject> types = new WeightedTable();
    private Function<Location<Extent>, PopulatorObject> override = null;

    @Override
    public PopulatorType getType() {
        return PopulatorTypes.FOREST;
    }

    @Override
    public void populate(org.spongepowered.api.world.World world, Extent extent, Random random) {
        Vector3i min = extent.getBlockMin();
        Vector3i size = extent.getBlockSize();
        int n = this.count.getFlooredAmount(random);
        for (int i = 0; i < n; ++i) {
            PopulatorObject type;
            int x = random.nextInt(size.getX());
            int z = random.nextInt(size.getZ());
            BlockPos pos = ((World)world).func_175672_r(new BlockPos(min.getX() + x, min.getY(), min.getZ() + z));
            if (this.override != null) {
                Location<Extent> pos2 = new Location<Extent>(extent, VecHelper.toVector3i(pos));
                type = this.override.apply(pos2);
            } else {
                List<PopulatorObject> result = this.types.get(random);
                if (result.isEmpty()) continue;
                type = result.get(0);
            }
            if (!type.canPlaceAt(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) continue;
            type.placeObject(world, random, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    @Override
    public VariableAmount getTreesPerChunk() {
        return this.count;
    }

    @Override
    public void setTreesPerChunk(VariableAmount count) {
        this.count = count;
    }

    @Override
    public WeightedTable<PopulatorObject> getTypes() {
        return this.types;
    }

    @Override
    public Optional<Function<Location<Extent>, PopulatorObject>> getSupplierOverride() {
        return Optional.ofNullable(this.override);
    }

    @Override
    public void setSupplierOverride(@Nullable Function<Location<Extent>, PopulatorObject> override) {
        this.override = override;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("count", this.count).add("types", this.types).toString();
    }
}

