/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.populators;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.PopulatorTypes;
import org.spongepowered.api.world.gen.populator.RandomBlock;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.util.VecHelper;

public class RandomBlockPopulator
implements RandomBlock {
    private VariableAmount count;
    private VariableAmount height;
    private Predicate<Location<World>> check;
    private BlockState state;

    public RandomBlockPopulator(BlockState block, VariableAmount count, VariableAmount height) {
        this.count = Preconditions.checkNotNull(count);
        this.state = Preconditions.checkNotNull(block);
        this.height = Preconditions.checkNotNull(height);
        this.check = t -> true;
    }

    public RandomBlockPopulator(BlockState block, VariableAmount count, VariableAmount height, Predicate<Location<World>> check) {
        this.count = Preconditions.checkNotNull(count);
        this.state = Preconditions.checkNotNull(block);
        this.height = Preconditions.checkNotNull(height);
        this.check = Preconditions.checkNotNull(check);
    }

    @Override
    public PopulatorType getType() {
        return PopulatorTypes.GENERIC_BLOCK;
    }

    @Override
    public void populate(World world, Extent extent, Random random) {
        Vector3i min = extent.getBlockMin();
        Vector3i size = extent.getBlockSize();
        int n = this.count.getFlooredAmount(random);
        Location<World> chunkMin = new Location<World>(world, min.getX(), min.getY(), min.getZ());
        for (int i = 0; i < n; ++i) {
            Location<World> pos = chunkMin.add(random.nextInt(size.getX()), this.height.getFlooredAmount(random), random.nextInt(size.getZ()));
            if (!this.check.test(pos)) continue;
            if (((WorldBridge)((Object)world)).bridge$isFake()) {
                world.setBlock(pos.getBlockPosition(), this.state, BlockChangeFlags.PHYSICS_OBSERVER);
            } else {
                PhaseTracker.getInstance().setBlockState((WorldServerBridge)((Object)world), VecHelper.toBlockPos(pos), (IBlockState)this.state, BlockChangeFlags.PHYSICS_OBSERVER);
            }
            try {
                ((WorldServer)world).func_189507_a(VecHelper.toBlockPos(pos), (IBlockState)this.state, random);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Override
    public BlockState getBlock() {
        return this.state;
    }

    @Override
    public void setBlock(BlockState block) {
        this.state = Preconditions.checkNotNull(block);
    }

    @Override
    public VariableAmount getAttemptsPerChunk() {
        return this.count;
    }

    @Override
    public void setAttemptsPerChunk(VariableAmount count) {
        this.count = Preconditions.checkNotNull(count);
    }

    @Override
    public Predicate<Location<World>> getPlacementTarget() {
        return this.check;
    }

    @Override
    public void getPlacementTarget(Predicate<Location<World>> target) {
        this.check = Preconditions.checkNotNull(target);
    }

    @Override
    public VariableAmount getHeightRange() {
        return this.height;
    }

    @Override
    public void setHeightRange(VariableAmount height) {
        this.height = Preconditions.checkNotNull(height);
    }
}

