/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.populators;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import java.util.Random;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;
import org.spongepowered.api.world.gen.PopulatorObject;
import org.spongepowered.api.world.gen.PopulatorType;
import org.spongepowered.api.world.gen.PopulatorTypes;
import org.spongepowered.api.world.gen.populator.RandomObject;

public class RandomObjectPopulator
implements RandomObject {
    private VariableAmount count;
    private VariableAmount height;
    private double chance;
    private PopulatorObject obj;

    public RandomObjectPopulator(PopulatorObject obj, VariableAmount count, VariableAmount height) {
        this(obj, count, height, 1.0);
    }

    public RandomObjectPopulator(PopulatorObject obj, VariableAmount count, VariableAmount height, double chance) {
        this.obj = Preconditions.checkNotNull(obj);
        this.count = Preconditions.checkNotNull(count);
        this.height = Preconditions.checkNotNull(height);
        Preconditions.checkArgument(!Double.isNaN(chance), "Chance must be a number.");
        Preconditions.checkArgument(!Double.isInfinite(chance), "Chance cannot be infinite.");
        Preconditions.checkArgument(chance >= 0.0, "Chance cannot be negative.");
        this.chance = chance;
    }

    @Override
    public PopulatorType getType() {
        return PopulatorTypes.GENERIC_OBJECT;
    }

    @Override
    public void populate(World world, Extent extent, Random random) {
        Vector3i min = extent.getBlockMin();
        Vector3i size = extent.getBlockSize();
        int n = this.count.getFlooredAmount(random);
        int x = min.getX();
        int y = min.getY();
        int z = min.getZ();
        for (int i = 0; i < n; ++i) {
            int z0;
            int y0;
            int x0;
            if (!(random.nextDouble() < this.chance) || !this.obj.canPlaceAt(world, x0 = x + random.nextInt(size.getX()), y0 = y + this.height.getFlooredAmount(random), z0 = z + random.nextInt(size.getZ()))) continue;
            this.obj.placeObject(world, random, x0, y0, z0);
        }
    }

    @Override
    public VariableAmount getAttemptsPerChunk() {
        return this.count;
    }

    @Override
    public void setAttemptsPerChunk(VariableAmount count) {
        this.count = count;
    }

    @Override
    public VariableAmount getHeightRange() {
        return this.height;
    }

    @Override
    public void setHeightRange(VariableAmount height) {
        this.height = height;
    }

    @Override
    public PopulatorObject getObject() {
        return this.obj;
    }

    @Override
    public void setObject(PopulatorObject obj) {
        this.obj = obj;
    }

    @Override
    public double getSpawnChance() {
        return this.chance;
    }

    @Override
    public void setSpawnChance(double chance) {
        this.chance = chance;
    }
}

