/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.gen.type;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import org.spongepowered.api.world.gen.PopulatorObject;
import org.spongepowered.api.world.gen.type.MushroomType;
import org.spongepowered.common.world.gen.type.SpongeBiomeTreeType;

public class SpongeMushroomType
implements MushroomType {
    private final String name;
    private final String id;
    private PopulatorObject obj;

    public SpongeMushroomType(String id, String name, PopulatorObject o) {
        this.id = id;
        this.name = name;
        this.obj = o;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public PopulatorObject getPopulatorObject() {
        return this.obj;
    }

    @Override
    public void setPopulatorObject(PopulatorObject object) {
        this.obj = Preconditions.checkNotNull(object);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpongeBiomeTreeType)) {
            return false;
        }
        SpongeBiomeTreeType b2 = (SpongeBiomeTreeType)o;
        return this.getId().equals(b2.getId());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.getId()).add("popobj", this.obj.getClass().getName()).toString();
    }
}

