/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.storage;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.common.util.Constants;

public class SpongePlayerData
implements DataSerializable {
    UUID uuid;
    long firstJoined;
    long lastJoined;

    SpongePlayerData() {
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("uuid", this.uuid).add("firstJoined", this.firstJoined).add("lastJoined", this.lastJoined).toString();
    }

    public int hashCode() {
        return Objects.hash(this.uuid, this.firstJoined, this.lastJoined);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SpongePlayerData other = (SpongePlayerData)obj;
        return Objects.equals(this.uuid, other.uuid) && Objects.equals(this.firstJoined, other.firstJoined) && Objects.equals(this.lastJoined, other.lastJoined);
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew().set(Queries.CONTENT_VERSION, (Object)this.getContentVersion()).set(Constants.Entity.Player.UUID, (Object)this.uuid.toString()).set(Constants.Sponge.PlayerData.PLAYER_DATA_JOIN, (Object)this.firstJoined).set(Constants.Sponge.PlayerData.PLAYER_DATA_LAST, (Object)this.lastJoined);
    }

    public static final class Builder
    extends AbstractDataBuilder<SpongePlayerData>
    implements DataBuilder<SpongePlayerData> {
        public Builder() {
            super(SpongePlayerData.class, 1);
        }

        @Override
        protected Optional<SpongePlayerData> buildContent(DataView container) throws InvalidDataException {
            if (container.contains(Constants.Entity.Player.UUID, Constants.Sponge.PlayerData.PLAYER_DATA_JOIN, Constants.Sponge.PlayerData.PLAYER_DATA_LAST)) {
                String idString = container.getString(Constants.Entity.Player.UUID).get();
                UUID uuid = UUID.fromString(idString);
                long firstJoin = container.getLong(Constants.Sponge.PlayerData.PLAYER_DATA_JOIN).get();
                long lastJoin = container.getLong(Constants.Sponge.PlayerData.PLAYER_DATA_LAST).get();
                SpongePlayerData data = new SpongePlayerData();
                data.uuid = uuid;
                data.firstJoined = firstJoin;
                data.lastJoined = lastJoin;
                return Optional.of(data);
            }
            return Optional.empty();
        }
    }
}

