/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.meta;

import com.google.common.collect.ImmutableMap;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.spongepowered.plugin.meta.PluginMetadata;
import org.spongepowered.plugin.meta.gson.ModMetadataAdapter;
import org.spongepowered.plugin.meta.gson.ModMetadataCollectionAdapter;

public final class McModInfo {
    public static final String STANDARD_FILENAME = "mcmod.info";
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final String INDENT = "    ";
    public static final McModInfo DEFAULT = new McModInfo(ModMetadataCollectionAdapter.DEFAULT);
    private final ModMetadataCollectionAdapter adapter;

    private McModInfo(ModMetadataCollectionAdapter adapter) {
        this.adapter = adapter;
    }

    public List<PluginMetadata> fromJson(String json) {
        try {
            return (List)this.adapter.fromJson(json);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    public List<PluginMetadata> read(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path, CHARSET);){
            List<PluginMetadata> list = this.read(reader);
            return list;
        }
    }

    public List<PluginMetadata> read(InputStream in) throws IOException {
        return (List)this.adapter.fromJson(new BufferedReader(new InputStreamReader(in, CHARSET)));
    }

    public List<PluginMetadata> read(Reader reader) throws IOException {
        return (List)this.adapter.fromJson(reader);
    }

    public List<PluginMetadata> read(JsonReader reader) throws IOException {
        return this.adapter.read(reader);
    }

    public String toJson(PluginMetadata ... meta) {
        return this.toJson(Arrays.asList(meta));
    }

    public String toJson(List<PluginMetadata> meta) {
        StringWriter writer = new StringWriter();
        try {
            this.write((Writer)writer, meta);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
        return writer.toString();
    }

    public void write(Path path, PluginMetadata ... meta) throws IOException {
        this.write(path, Arrays.asList(meta));
    }

    public void write(Path path, List<PluginMetadata> meta) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(path, CHARSET, new OpenOption[0]);){
            this.write((Writer)writer, meta);
        }
    }

    public void write(Writer writer, PluginMetadata ... meta) throws IOException {
        this.write(writer, Arrays.asList(meta));
    }

    public void write(Writer writer, List<PluginMetadata> meta) throws IOException {
        try (JsonWriter json = new JsonWriter(writer);){
            json.setIndent(INDENT);
            this.write(json, meta);
            writer.write(10);
        }
    }

    public void write(JsonWriter writer, PluginMetadata ... meta) throws IOException {
        this.write(writer, Arrays.asList(meta));
    }

    public void write(JsonWriter writer, List<PluginMetadata> meta) throws IOException {
        this.adapter.write(writer, meta);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final GsonBuilder gson = new GsonBuilder();
        private final ImmutableMap.Builder<String, Class<?>> extensions = ImmutableMap.builder();

        private Builder() {
        }

        public GsonBuilder gson() {
            return this.gson;
        }

        public Builder registerExtension(String key, Class<?> extensionClass) {
            this.extensions.put(key, extensionClass);
            return this;
        }

        public Builder registerExtension(String key, Class<?> extensionClass, Object typeAdapter) {
            this.registerExtension(key, extensionClass);
            this.gson.registerTypeAdapter(extensionClass, typeAdapter);
            return this;
        }

        public McModInfo build() {
            return new McModInfo(new ModMetadataCollectionAdapter(new ModMetadataAdapter(this.gson.create(), this.extensions.build())));
        }
    }
}

