/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.meta;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.annotation.Nullable;

public final class PluginDependency {
    private final LoadOrder loadOrder;
    private final String id;
    @Nullable
    private final String version;
    private final boolean optional;

    public PluginDependency(LoadOrder loadOrder, String id, @Nullable String version, boolean optional) {
        this.loadOrder = Preconditions.checkNotNull(loadOrder, "loadOrder");
        this.id = Preconditions.checkNotNull(id, "id");
        Preconditions.checkArgument(!id.isEmpty(), "id cannot be empty");
        this.version = Strings.emptyToNull(version);
        this.optional = optional;
    }

    public LoadOrder getLoadOrder() {
        return this.loadOrder;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public PluginDependency optional() {
        return this.setOptional(true);
    }

    public PluginDependency required() {
        return this.setOptional(false);
    }

    private PluginDependency setOptional(boolean optional) {
        if (this.optional == optional) {
            return this;
        }
        return new PluginDependency(this.loadOrder, this.id, this.version, optional);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginDependency that = (PluginDependency)o;
        return this.loadOrder == that.loadOrder && this.id.equals(that.id) && Objects.equal(this.version, that.version) && this.optional == that.optional;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.loadOrder, this.id, this.version, this.optional});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().addValue((Object)this.loadOrder).add("id", (Object)this.id).add("version", (Object)this.version).add("optional", this.optional).toString();
    }

    public static enum LoadOrder {
        NONE,
        BEFORE,
        AFTER;

    }
}

