/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.meta;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.spongepowered.plugin.meta.PluginDependency;

public final class PluginMetadata
implements Consumer<PluginMetadata> {
    public static final Pattern ID_PATTERN = Pattern.compile("[a-z][a-z0-9-_]{0,63}");
    private String id;
    @Nullable
    private String name;
    @Nullable
    private String version;
    @Nullable
    private String description;
    @Nullable
    private String url;
    private final List<String> authors = new ArrayList<String>();
    private final Map<String, PluginDependency> dependencies = new HashMap<String, PluginDependency>();
    private final Map<String, Object> extensions = new LinkedHashMap<String, Object>();

    public PluginMetadata(String id) {
        this.setId(id);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        Preconditions.checkNotNull(id, "id");
        Preconditions.checkArgument(!id.isEmpty(), "id cannot be empty");
        this.id = id;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = Strings.emptyToNull(name);
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    public void setVersion(@Nullable String version) {
        this.version = Strings.emptyToNull(version);
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = Strings.emptyToNull(description);
    }

    @Nullable
    public String getUrl() {
        return this.url;
    }

    public void setUrl(@Nullable String url) {
        this.url = Strings.emptyToNull(url);
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public void addAuthor(String author) {
        Preconditions.checkNotNull(author, "author");
        Preconditions.checkArgument(!author.isEmpty(), "Author cannot be empty");
        this.authors.add(author);
    }

    public boolean removeAuthor(String author) {
        return this.authors.remove(author);
    }

    public Collection<PluginDependency> getDependencies() {
        return this.dependencies.values();
    }

    public Map<String, PluginDependency> getDependenciesById() {
        return Collections.unmodifiableMap(this.dependencies);
    }

    public Set<PluginDependency> collectRequiredDependencies() {
        if (this.dependencies.isEmpty()) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (PluginDependency dependency : this.dependencies.values()) {
            if (dependency.isOptional()) continue;
            builder.add(dependency);
        }
        return builder.build();
    }

    public Map<PluginDependency.LoadOrder, Set<PluginDependency>> groupDependenciesByLoadOrder() {
        if (this.dependencies.isEmpty()) {
            return ImmutableMap.of();
        }
        EnumMap<PluginDependency.LoadOrder, ImmutableCollection> map = new EnumMap<PluginDependency.LoadOrder, ImmutableCollection>(PluginDependency.LoadOrder.class);
        for (PluginDependency.LoadOrder order : PluginDependency.LoadOrder.values()) {
            ImmutableSet.Builder dependencies = ImmutableSet.builder();
            for (PluginDependency dependency : this.dependencies.values()) {
                if (dependency.getLoadOrder() != order) continue;
                dependencies.add(dependency);
            }
            map.put(order, dependencies.build());
        }
        return Maps.immutableEnumMap(map);
    }

    @Nullable
    public PluginDependency getDependency(String id) {
        return this.dependencies.get(id);
    }

    public void addDependency(PluginDependency dependency) {
        String id = dependency.getId();
        Preconditions.checkArgument(!this.dependencies.containsKey(id), "Duplicate dependency with plugin ID: %s", new Object[]{id});
        this.dependencies.put(id, dependency);
    }

    public PluginDependency replaceDependency(PluginDependency dependency) {
        return this.dependencies.put(dependency.getId(), dependency);
    }

    public boolean removeDependency(String id) {
        return this.dependencies.remove(id) != null;
    }

    public Map<String, Object> getExtensions() {
        return Collections.unmodifiableMap(this.extensions);
    }

    @Nullable
    public <T> T getExtension(String key) {
        return (T)this.extensions.get(key);
    }

    public void setExtension(String key, Object extension) {
        Preconditions.checkNotNull(extension, "extension");
        this.extensions.put(key, extension);
    }

    public boolean removeExtension(String key) {
        return this.extensions.remove(key) != null;
    }

    @Override
    public void accept(PluginMetadata other) {
        Preconditions.checkArgument(this.id.equals(other.id), "Plugin IDs don't match");
        if (other.name != null) {
            this.name = other.name;
        }
        if (other.version != null) {
            this.version = other.version;
        }
        if (other.description != null) {
            this.description = other.description;
        }
        if (other.url != null) {
            this.url = other.url;
        }
        if (!other.authors.isEmpty()) {
            this.authors.clear();
            this.authors.addAll(other.authors);
        }
        other.getDependencies().forEach(this::replaceDependency);
        other.getExtensions().forEach(this::mergeExtension);
    }

    private void mergeExtension(String key, Object extension) {
        Object currentValue = this.extensions.get(key);
        if (currentValue == null) {
            this.extensions.put(key, extension);
            return;
        }
        if (currentValue instanceof Map && extension instanceof Map) {
            ((Map)currentValue).putAll((Map)extension);
            return;
        }
        this.extensions.put(key, extension);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("version", (Object)this.version).add("description", (Object)this.description).add("url", (Object)this.url).add("authors", this.authors).add("dependencies", this.dependencies).add("extensions", this.extensions).toString();
    }
}

