/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.plugin.processor;

import com.google.common.base.Splitter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.plugin.meta.McModInfo;
import org.spongepowered.plugin.meta.PluginMetadata;
import org.spongepowered.plugin.processor.AnnotationWrapper;
import org.spongepowered.plugin.processor.PluginElement;
import org.spongepowered.plugin.processor.PluginProcessException;
import org.spongepowered.plugin.processor.ProcessorUtils;

@SupportedAnnotationTypes(value={"org.spongepowered.api.plugin.Plugin", "org.spongepowered.api.plugin.Dependency"})
@SupportedOptions(value={"extraMetadataFiles", "metadataOutputFile"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class PluginProcessor
extends AbstractProcessor {
    static final String PLUGIN_PACKAGE = "org.spongepowered.api.plugin.";
    static final String PLUGIN_ANNOTATION_CLASS = "org.spongepowered.api.plugin.Plugin";
    static final String DEPENDENCY_ANNOTATION_CLASS = "org.spongepowered.api.plugin.Dependency";
    public static final String EXTRA_FILES_OPTION = "extraMetadataFiles";
    public static final String OUTPUT_FILE_OPTION = "metadataOutputFile";
    private static final Splitter FILE_SPLITTER = Splitter.on(';');
    private final Map<String, PluginMetadata> meta = new HashMap<String, PluginMetadata>();
    private final Map<String, PluginElement> plugins = new HashMap<String, PluginElement>();
    private final Set<String> duplicates = new HashSet<String>();
    private Path outputPath;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        String outputFile;
        super.init(processingEnv);
        String extraFiles = processingEnv.getOptions().get(EXTRA_FILES_OPTION);
        if (extraFiles != null && !extraFiles.isEmpty()) {
            for (String file : FILE_SPLITTER.split(extraFiles)) {
                Path path = Paths.get(file, new String[0]);
                this.getMessager().printMessage(Diagnostic.Kind.NOTE, "Reading extra plugin metadata from " + path);
                try {
                    for (PluginMetadata meta : McModInfo.DEFAULT.read(path)) {
                        PluginMetadata base = this.meta.putIfAbsent(meta.getId(), meta);
                        if (base == null) continue;
                        base.accept(meta);
                    }
                }
                catch (IOException e) {
                    throw new PluginProcessException("Failed to read extra plugin metadata from " + path, e);
                }
            }
        }
        if ((outputFile = processingEnv.getOptions().get(OUTPUT_FILE_OPTION)) != null && !outputFile.isEmpty()) {
            this.outputPath = Paths.get(outputFile, new String[0]);
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            if (!roundEnv.errorRaised()) {
                this.finish();
            }
            return false;
        }
        if (!ProcessorUtils.contains(annotations, Plugin.class)) {
            return false;
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Plugin.class)) {
            if (element.getKind() != ElementKind.CLASS) {
                this.getMessager().printMessage(Diagnostic.Kind.ERROR, "Invalid element of type " + (Object)((Object)element.getKind()) + " annotated with @Plugin", element);
                continue;
            }
            TypeElement pluginElement = (TypeElement)element;
            AnnotationWrapper<Plugin> annotation = AnnotationWrapper.of(pluginElement, Plugin.class);
            String id = annotation.get().id();
            if (id.isEmpty()) {
                this.getMessager().printMessage(Diagnostic.Kind.ERROR, "Plugin ID cannot be empty", pluginElement, annotation.getMirror(), annotation.getValue("id"));
                continue;
            }
            PluginMetadata meta = this.meta.remove(id);
            if (meta == null) {
                meta = new PluginMetadata(id);
            }
            PluginElement plugin = new PluginElement(pluginElement, annotation, meta);
            if (this.duplicates.contains(id) || this.plugins.containsKey(id)) {
                PluginElement otherPlugin = this.plugins.remove(id);
                if (otherPlugin != null) {
                    this.reportDuplicatePlugin(id, otherPlugin);
                    this.duplicates.add(id);
                }
                this.reportDuplicatePlugin(id, plugin);
                continue;
            }
            this.plugins.put(id, plugin);
            plugin.apply(this.getMessager());
        }
        return false;
    }

    private void finish() {
        if (!this.meta.isEmpty()) {
            this.getMessager().printMessage(Diagnostic.Kind.WARNING, "The following extra plugin IDs were not found: " + this.meta.keySet());
        }
        List<PluginMetadata> meta = this.plugins.values().stream().map(PluginElement::getMetadata).collect(Collectors.toList());
        meta.addAll(this.meta.values());
        try (BufferedWriter writer = this.createWriter();){
            McModInfo.DEFAULT.write((Writer)writer, meta);
        }
        catch (IOException e) {
            throw new PluginProcessException("Failed to write plugin metadata", e);
        }
    }

    private BufferedWriter createWriter() throws IOException {
        if (this.outputPath != null) {
            this.getMessager().printMessage(Diagnostic.Kind.NOTE, "Writing plugin metadata to " + this.outputPath);
            return Files.newBufferedWriter(this.outputPath, new OpenOption[0]);
        }
        FileObject obj = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "mcmod.info", new Element[0]);
        this.getMessager().printMessage(Diagnostic.Kind.NOTE, "Writing plugin metadata to " + obj.toUri());
        return new BufferedWriter(obj.openWriter());
    }

    private void reportDuplicatePlugin(String id, PluginElement plugin) {
        this.getMessager().printMessage(Diagnostic.Kind.ERROR, "Duplicate plugin ID: " + id, plugin.getElement(), plugin.getAnnotation().getMirror(), plugin.getAnnotation().getValue("id"));
    }

    private Messager getMessager() {
        return this.processingEnv.getMessager();
    }
}

