/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.inject;

import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Server;
import org.spongepowered.api.event.EventManager;
import org.spongepowered.api.network.ChannelRegistrar;
import org.spongepowered.api.plugin.PluginManager;
import org.spongepowered.common.SpongeGame;
import org.spongepowered.common.SpongePlatform;
import org.spongepowered.common.event.SpongeEventManager;
import org.spongepowered.common.inject.SpongeImplementationModule;
import org.spongepowered.server.VanillaGame;
import org.spongepowered.server.network.VanillaChannelRegistrar;
import org.spongepowered.server.plugin.MetadataContainer;
import org.spongepowered.server.plugin.VanillaPluginManager;

public class SpongeVanillaModule
extends SpongeImplementationModule {
    private final MinecraftServer server;
    private final MetadataContainer metadata;

    public SpongeVanillaModule(MinecraftServer server, MetadataContainer metadata) {
        this.server = server;
        this.metadata = metadata;
    }

    @Override
    protected void configure() {
        super.configure();
        this.bind(SpongeGame.class).to(VanillaGame.class);
        this.bind(Platform.class).to(SpongePlatform.class);
        this.bind(PluginManager.class).to(VanillaPluginManager.class);
        this.bind(EventManager.class).to(SpongeEventManager.class);
        this.bind(ChannelRegistrar.class).to(VanillaChannelRegistrar.class);
        this.bind(Server.class).toInstance((Server)((Object)this.server));
        this.bind(MetadataContainer.class).toInstance(this.metadata);
        this.requestStaticInjection(DedicatedServer.class);
    }
}

