/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.launch;

import com.google.common.base.Preconditions;
import java.io.IOException;
import net.minecraft.launchwrapper.Launch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.server.launch.transformer.deobf.SrgRemapper;

public final class VanillaLaunch {
    public static final Environment ENVIRONMENT = VanillaLaunch.detectEnvironment();
    private static final Logger logger = LogManager.getLogger("Sponge");
    private static SrgRemapper remapper = SrgRemapper.NONE;

    private VanillaLaunch() {
    }

    public static Logger getLogger() {
        return logger;
    }

    public static SrgRemapper getRemapper() {
        return remapper;
    }

    public static void setRemapper(SrgRemapper newRemapper) {
        Preconditions.checkState(remapper == SrgRemapper.NONE, "Remapper was already set");
        remapper = newRemapper;
    }

    private static Environment detectEnvironment() {
        try {
            if (Launch.classLoader.getClassBytes("net.minecraft.server.dedicated.DedicatedServer") != null) {
                return Environment.DEVELOPMENT;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Environment.PRODUCTION;
    }

    public static enum Environment {
        DEVELOPMENT,
        PRODUCTION;

    }
}

