/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.launch.plugin;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.spongepowered.plugin.meta.PluginDependency;
import org.spongepowered.plugin.meta.PluginMetadata;
import org.spongepowered.plugin.meta.version.DefaultArtifactVersion;
import org.spongepowered.plugin.meta.version.InvalidVersionSpecificationException;
import org.spongepowered.plugin.meta.version.VersionRange;
import org.spongepowered.server.launch.VanillaLaunch;
import org.spongepowered.server.launch.plugin.PluginSource;

public final class PluginCandidate {
    private String id;
    private final String pluginClass;
    private final PluginSource source;
    private PluginMetadata metadata;
    private boolean invalid;
    @Nullable
    private Set<PluginCandidate> dependencies;
    @Nullable
    private Set<PluginCandidate> requirements;
    private final Set<String> dependenciesWithUnknownVersion = new HashSet<String>();
    @Nullable
    private Map<String, String> versions;
    @Nullable
    private Map<String, String> missingRequirements;

    PluginCandidate(String pluginClass, PluginSource source, PluginMetadata metadata) {
        this.pluginClass = Preconditions.checkNotNull(pluginClass, "pluginClass");
        this.source = Preconditions.checkNotNull(source, "source");
        this.metadata = Preconditions.checkNotNull(metadata, "metadata");
        this.id = metadata.getId();
    }

    public String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    public String getPluginClass() {
        return this.pluginClass;
    }

    public PluginSource getSource() {
        return this.source;
    }

    public PluginMetadata getMetadata() {
        return this.metadata;
    }

    void setMetadata(PluginMetadata metadata) {
        this.metadata = Preconditions.checkNotNull(metadata, "metadata");
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public boolean isLoadable() {
        return !this.invalid && this.getMissingRequirements().isEmpty();
    }

    public boolean dependenciesCollected() {
        return this.dependencies != null;
    }

    private void ensureState() {
        Preconditions.checkState(this.dependenciesCollected(), "Dependencies not collected yet");
    }

    public Set<PluginCandidate> getDependencies() {
        this.ensureState();
        return this.dependencies;
    }

    public Set<PluginCandidate> getRequirements() {
        this.ensureState();
        return this.requirements;
    }

    public Map<String, String> getMissingRequirements() {
        this.ensureState();
        return this.missingRequirements;
    }

    public String getVersion(String id) {
        this.ensureState();
        return this.versions.get(id);
    }

    public boolean updateRequirements() {
        this.ensureState();
        if (this.requirements.isEmpty()) {
            return false;
        }
        Iterator<PluginCandidate> itr = this.requirements.iterator();
        while (itr.hasNext()) {
            PluginCandidate candidate = itr.next();
            if (candidate.isLoadable()) continue;
            itr.remove();
            this.missingRequirements.put(candidate.getId(), this.versions.get(candidate.getId()));
        }
        return this.invalid || !this.missingRequirements.isEmpty();
    }

    public boolean collectDependencies(Map<String, String> loadedPlugins, Map<String, PluginCandidate> candidates) {
        Preconditions.checkState(this.dependencies == null, "Dependencies already collected");
        if (loadedPlugins.containsKey(this.id)) {
            this.invalid = true;
        }
        this.dependencies = new HashSet<PluginCandidate>();
        this.requirements = new HashSet<PluginCandidate>();
        this.versions = new HashMap<String, String>();
        this.missingRequirements = new HashMap<String, String>();
        for (PluginDependency dependency : this.metadata.collectRequiredDependencies()) {
            String id = dependency.getId();
            if (this.id.equals(id)) {
                VanillaLaunch.getLogger().warn("Plugin '{}' from {} requires itself to be loaded. This is redundant and can be removed from the dependencies.", (Object)this.id, (Object)this.source);
                continue;
            }
            String version = dependency.getVersion();
            if (loadedPlugins.containsKey(id)) {
                if (this.verifyVersionRange(id, version, loadedPlugins.get(id))) continue;
                this.missingRequirements.put(id, version);
                continue;
            }
            PluginCandidate candidate = candidates.get(id);
            if (candidate != null && this.verifyVersionRange(id, version, candidate.getMetadata().getVersion())) {
                this.requirements.add(candidate);
                continue;
            }
            this.missingRequirements.put(id, version);
        }
        Map<PluginDependency.LoadOrder, Set<PluginDependency>> dependencies = this.metadata.groupDependenciesByLoadOrder();
        this.collectOptionalDependencies((Iterable<PluginDependency>)dependencies.get((Object)PluginDependency.LoadOrder.BEFORE), loadedPlugins, candidates);
        Set<PluginDependency> loadAfter = dependencies.get((Object)PluginDependency.LoadOrder.AFTER);
        if (loadAfter != null && !loadAfter.isEmpty()) {
            this.invalid = true;
            VanillaLaunch.getLogger().error("Invalid dependency with load order AFTER on plugin '{}' from {}. This is currently not supported for Sponge plugins! Requested dependencies: {}", (Object)this.id, (Object)this.source, (Object)loadAfter);
        }
        return this.isLoadable();
    }

    private void collectOptionalDependencies(@Nullable Iterable<PluginDependency> dependencies, Map<String, String> loadedPlugins, Map<String, PluginCandidate> candidates) {
        if (dependencies == null) {
            return;
        }
        for (PluginDependency dependency : dependencies) {
            String id = dependency.getId();
            if (this.id.equals(id)) {
                VanillaLaunch.getLogger().error("Plugin '{}' from {} cannot have a dependency on itself. This is redundant and should be removed.", (Object)this.id, (Object)this.source);
                this.invalid = true;
                continue;
            }
            String version = dependency.getVersion();
            if (loadedPlugins.containsKey(id)) {
                if (this.verifyVersionRange(id, version, loadedPlugins.get(id))) continue;
                this.missingRequirements.put(id, version);
                continue;
            }
            PluginCandidate candidate = candidates.get(id);
            if (candidate == null) continue;
            if (this.verifyVersionRange(id, version, candidate.getMetadata().getVersion())) {
                this.dependencies.add(candidate);
                continue;
            }
            this.missingRequirements.put(id, version);
        }
    }

    private boolean verifyVersionRange(String id, @Nullable String expectedRange, @Nullable String version) {
        block12: {
            if (expectedRange == null) {
                return true;
            }
            if (expectedRange.equals(this.missingRequirements.get(id))) {
                return false;
            }
            if (expectedRange.equals(this.versions.get(id))) {
                return true;
            }
            if (version != null) {
                try {
                    BigInteger majorInstalled;
                    BigInteger majorExpected;
                    VersionRange range = VersionRange.createFromVersionSpec(expectedRange);
                    DefaultArtifactVersion installedVersion = new DefaultArtifactVersion(version);
                    if (!range.containsVersion(installedVersion)) break block12;
                    String currentRange = this.versions.get(id);
                    if (currentRange != null) {
                        VersionRange otherRange;
                        try {
                            otherRange = VersionRange.createFromVersionSpec(currentRange);
                        }
                        catch (InvalidVersionSpecificationException e) {
                            throw new AssertionError((Object)e);
                        }
                        expectedRange = otherRange.restrict(range).toString();
                    }
                    this.versions.put(id, expectedRange);
                    if (range.getRecommendedVersion() instanceof DefaultArtifactVersion && (majorExpected = ((DefaultArtifactVersion)range.getRecommendedVersion()).getVersion().getFirstInteger()) != null && (majorInstalled = installedVersion.getVersion().getFirstInteger()) != null && (!majorExpected.equals(majorInstalled) || installedVersion.compareTo(range.getRecommendedVersion()) < 0)) {
                        VanillaLaunch.getLogger().warn("Plugin {} from {} was designed for {} {}. It may not work properly.", (Object)this.id, (Object)this.source, (Object)id, (Object)range.getRecommendedVersion());
                    }
                    return true;
                }
                catch (InvalidVersionSpecificationException e) {
                    VanillaLaunch.getLogger().error("Failed to parse version range {} for dependency {} of plugin {} from {}: {}", (Object)version, (Object)id, (Object)this.id, (Object)this.source, (Object)e.getMessage());
                    this.invalid = true;
                }
            } else {
                if (this.dependenciesWithUnknownVersion.add(id)) {
                    VanillaLaunch.getLogger().warn("Cannot check version of dependency {} for plugin {} from {}: Version of dependency unknown", (Object)id, (Object)this.id, (Object)this.source);
                }
                return true;
            }
        }
        return false;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginCandidate candidate = (PluginCandidate)o;
        return this.id.equals(candidate.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(this).omitNullValues().add("id", this.id).add("class", this.pluginClass).add("source", this.source);
        if (this.invalid) {
            helper.addValue("INVALID");
        } else if (this.missingRequirements != null && !this.missingRequirements.isEmpty()) {
            helper.addValue("FAILED");
        }
        return helper.toString();
    }
}

