/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.launch.plugin;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import javax.annotation.Nullable;
import org.spongepowered.common.launch.SpongeLaunch;
import org.spongepowered.server.launch.VanillaLaunch;
import org.spongepowered.server.launch.plugin.PluginCandidate;
import org.spongepowered.server.launch.plugin.PluginScanner;

public final class VanillaLaunchPluginManager {
    @Nullable
    private static Map<String, PluginCandidate> plugins;

    private VanillaLaunchPluginManager() {
    }

    public static void findPlugins(boolean scanClasspath, boolean scanFullClasspath) throws IOException {
        Path pluginsDir;
        VanillaLaunch.getLogger().info("Searching for plugins...");
        PluginScanner pluginScanner = new PluginScanner();
        if (scanClasspath || scanFullClasspath) {
            VanillaLaunch.getLogger().info("Scanning classpath for plugins...");
            ClassLoader loader = VanillaLaunch.class.getClassLoader();
            if (loader instanceof URLClassLoader) {
                pluginScanner.scanClassPath((URLClassLoader)loader, scanFullClasspath);
            } else {
                VanillaLaunch.getLogger().error("Cannot search for plugins on classpath: Unsupported class loader: {}", (Object)loader.getClass());
            }
        }
        if (Files.isDirectory(pluginsDir = SpongeLaunch.getPluginsDir(), new LinkOption[0])) {
            pluginScanner.scanDirectory(pluginsDir);
        } else {
            Files.createDirectories(pluginsDir, new FileAttribute[0]);
        }
        pluginsDir = SpongeLaunch.getAdditionalPluginsDir();
        if (Files.isDirectory(pluginsDir, new LinkOption[0])) {
            pluginScanner.scanDirectory(pluginsDir);
        }
        plugins = pluginScanner.getPlugins();
        VanillaLaunch.getLogger().info("{} plugin(s) found", (Object)plugins.size());
    }

    public static Map<String, PluginCandidate> getPlugins() {
        Preconditions.checkState(plugins != null, "Plugin folder was not scanned yet");
        Map<String, PluginCandidate> result = plugins;
        plugins = null;
        return result;
    }
}

