/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.launch.transformer.deobf;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URL;
import net.minecraft.launchwrapper.IClassNameTransformer;
import net.minecraft.launchwrapper.Launch;
import org.spongepowered.server.launch.transformer.deobf.DeobfuscationTransformer;
import org.spongepowered.server.launch.transformer.deobf.mappings.ClassMappings;
import org.spongepowered.server.launch.transformer.deobf.mappings.CompactMappingsReader;
import org.spongepowered.server.launch.transformer.deobf.mappings.MemberDescriptor;

public final class NotchDeobfuscationTransformer
extends DeobfuscationTransformer
implements IClassNameTransformer {
    private static final String MINECRAFT_PACKAGE_PREFIX = "net.minecraft.";
    private final ImmutableMap<String, ClassMappings> mappings;
    private final ImmutableMap<String, String> reverseClasses;

    public NotchDeobfuscationTransformer() throws IOException {
        URL mappings = (URL)Launch.blackboard.get("vanilla.cmap");
        CompactMappingsReader reader = new CompactMappingsReader();
        reader.read(mappings);
        this.mappings = reader.getMappings();
        this.reverseClasses = reader.getReverseClasses();
    }

    @Override
    protected boolean shouldTransformClass(String transformedName) {
        return transformedName.startsWith(MINECRAFT_PACKAGE_PREFIX);
    }

    @Override
    public String map(String className) {
        ClassMappings mappings = this.mappings.get(className);
        if (mappings == null) {
            return className;
        }
        return mappings.getMappedName();
    }

    @Override
    public String unmap(String className) {
        String name = this.reverseClasses.get(className);
        return name != null ? name : className;
    }

    @Override
    public String mapFieldName(String owner, String fieldName, String desc) {
        ClassMappings mappings = this.mappings.get(owner);
        if (mappings == null) {
            return fieldName;
        }
        String mappedName = mappings.getFields().get(new MemberDescriptor(fieldName, desc));
        return mappedName != null ? mappedName : fieldName;
    }

    @Override
    public String mapMethodName(String owner, String methodName, String desc) {
        ClassMappings mappings = this.mappings.get(owner);
        if (mappings == null) {
            return methodName;
        }
        String mappedName = mappings.getMethods().get(new MemberDescriptor(methodName, desc));
        return mappedName != null ? mappedName : methodName;
    }

    @Override
    public String mapSrgMethodIdentifier(String identifier) {
        return identifier;
    }

    public String remapClassName(String className) {
        return this.map(className.replace('.', '/')).replace('/', '.');
    }

    public String unmapClassName(String className) {
        return this.unmap(className.replace('.', '/')).replace('/', '.');
    }
}

