/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.mixin.core.entity.player;

import com.flowpowered.math.vector.Vector3d;
import io.netty.util.internal.ConcurrentSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.block.BlockBed;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.action.SleepingEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.entity.player.EntityPlayerBridge;
import org.spongepowered.common.bridge.world.WorldInfoBridge;
import org.spongepowered.common.mixin.core.entity.EntityLivingBaseMixin;
import org.spongepowered.common.util.VecHelper;

@Mixin(value={EntityPlayer.class})
public abstract class EntityPlayerMixin_Vanilla
extends EntityLivingBaseMixin
implements EntityPlayerBridge {
    @Shadow
    protected boolean field_71083_bS;
    @Shadow
    @Nullable
    public BlockPos field_71081_bT;
    @Shadow
    private int field_71076_b;
    @Shadow
    @Nullable
    private BlockPos field_71077_c;
    @Shadow
    private boolean field_82248_d;
    Map<UUID, BlockPos> vanilla$spawnChunkMap = new ConcurrentHashMap<UUID, BlockPos>();
    Set<UUID> vanilla$spawnForcedSet = new ConcurrentSet<UUID>();

    @Shadow
    public abstract void func_180473_a(BlockPos var1, boolean var2);

    @Overwrite
    @Nullable
    public BlockPos func_180470_cg() {
        return this.bridge$getBedLocation(this.field_71093_bK);
    }

    @Override
    public BlockPos bridge$getBedLocation(int dimension) {
        return dimension == 0 ? this.field_71077_c : this.vanilla$spawnChunkMap.get(dimension);
    }

    @Overwrite
    public boolean func_82245_bX() {
        return this.bridge$isSpawnForced(this.field_71093_bK);
    }

    @Override
    public boolean bridge$isSpawnForced(int dimension) {
        return dimension == 0 ? this.field_82248_d : this.vanilla$spawnForcedSet.contains(dimension);
    }

    @Inject(method={"setSpawnPoint"}, at={@At(value="HEAD")}, cancellable=true)
    private void vanilla$onSetSpawnPoint(BlockPos pos, boolean forced, CallbackInfo ci) {
        if (this.field_71093_bK != 0) {
            this.vanilla$setSpawnChunk(pos, forced, this.field_70170_p);
            ci.cancel();
        }
    }

    private void vanilla$setSpawnChunk(@Nullable BlockPos pos, boolean forced, World dimension) {
        Integer dimensionId = ((WorldInfoBridge)dimension.func_72912_H()).bridge$getDimensionId();
        if (dimensionId == null) {
            return;
        }
        UUID id = ((org.spongepowered.api.world.World)dimension).getUniqueId();
        if (pos != null) {
            this.vanilla$spawnChunkMap.put(id, pos);
            if (forced) {
                this.vanilla$spawnForcedSet.add(id);
            } else {
                this.vanilla$spawnForcedSet.remove(id);
            }
        } else {
            this.vanilla$spawnChunkMap.remove(id);
            this.vanilla$spawnForcedSet.remove(id);
        }
    }

    @Inject(method={"readEntityFromNBT"}, at={@At(value="RETURN")})
    private void onReadEntityFromNBT(NBTTagCompound tagCompound, CallbackInfo ci) {
        NBTTagList spawnList = tagCompound.func_150295_c("Spawns", 10);
        for (int i = 0; i < spawnList.func_74745_c(); ++i) {
            NBTTagCompound spawnData = spawnList.func_150305_b(i);
            UUID spawnDim = spawnData.func_186857_a("UUID");
            int x = spawnData.func_74762_e("SpawnX");
            int y = spawnData.func_74762_e("SpawnY");
            int z = spawnData.func_74762_e("SpawnZ");
            this.vanilla$spawnChunkMap.put(spawnDim, new BlockPos(x, y, z));
            if (!spawnData.func_74767_n("SpawnForced")) continue;
            this.vanilla$spawnForcedSet.add(spawnDim);
        }
    }

    @Inject(method={"writeEntityToNBT"}, at={@At(value="RETURN")})
    private void vanilla$onWriteEntityToNBT(NBTTagCompound tagCompound, CallbackInfo ci) {
        NBTTagList spawnList = new NBTTagList();
        for (Map.Entry<UUID, BlockPos> entry : this.vanilla$spawnChunkMap.entrySet()) {
            UUID dim = entry.getKey();
            BlockPos spawn = entry.getValue();
            NBTTagCompound spawnData = new NBTTagCompound();
            spawnData.func_186854_a("UUID", dim);
            spawnData.func_74768_a("SpawnX", spawn.func_177958_n());
            spawnData.func_74768_a("SpawnY", spawn.func_177956_o());
            spawnData.func_74768_a("SpawnZ", spawn.func_177952_p());
            spawnData.func_74757_a("SpawnForced", this.vanilla$spawnForcedSet.contains(dim));
            spawnList.func_74742_a((NBTBase)spawnData);
        }
        tagCompound.func_74782_a("Spawns", (NBTBase)spawnList);
    }

    @Inject(method={"trySleep"}, at={@At(value="HEAD")}, cancellable=true)
    private void vanilla$onTrySleep(BlockPos bedPos, CallbackInfoReturnable<EntityPlayer.SleepResult> ci) {
        Sponge.getCauseStackManager().pushCause(this);
        SleepingEvent.Pre event = SpongeEventFactory.createSleepingEventPre(Sponge.getCauseStackManager().getCurrentCause(), ((org.spongepowered.api.world.World)this.field_70170_p).createSnapshot(bedPos.func_177958_n(), bedPos.func_177956_o(), bedPos.func_177952_p()), (Player)((Object)this));
        if (SpongeImpl.postEvent(event)) {
            ci.setReturnValue(EntityPlayer.SleepResult.OTHER_PROBLEM);
        }
        Sponge.getCauseStackManager().popCause();
    }

    @Overwrite
    public void func_70999_a(boolean immediately, boolean updateWorldFlag, boolean setSpawn) {
        Transform<org.spongepowered.api.world.World> newLocation = null;
        IBlockState iblockstate = this.field_70170_p.func_180495_p(this.field_71081_bT);
        if (this.field_71081_bT != null && iblockstate.func_177230_c() == Blocks.field_150324_C) {
            BlockPos blockpos = BlockBed.func_176468_a((World)this.field_70170_p, (BlockPos)this.field_71081_bT, (int)0);
            if (blockpos == null) {
                blockpos = this.field_71081_bT.func_177984_a();
            }
            newLocation = ((Player)((Object)this)).getTransform().setPosition(new Vector3d((float)blockpos.func_177958_n() + 0.5f, (float)blockpos.func_177956_o() + 0.1f, (float)blockpos.func_177952_p() + 0.5f));
        }
        BlockSnapshot bed = ((Player)((Object)this)).getWorld().createSnapshot(VecHelper.toVector3i(this.field_71081_bT));
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(this);
            SleepingEvent.Post event = SpongeEventFactory.createSleepingEventPost(frame.getCurrentCause(), bed, Optional.ofNullable(newLocation), (Player)((Object)this), setSpawn);
            if (SpongeImpl.postEvent(event)) {
                return;
            }
            this.func_70105_a(0.6f, 1.8f);
            if (newLocation != null) {
                event.getSpawnTransform().ifPresent(this::bridge$setLocationAndAngles);
                this.field_71083_bS = false;
                if (!this.field_70170_p.field_72995_K && updateWorldFlag) {
                    this.field_70170_p.func_72854_c();
                }
                int n = this.field_71076_b = immediately ? 0 : 100;
                if (setSpawn) {
                    this.func_180473_a(this.field_71081_bT, false);
                }
                SpongeImpl.postEvent(SpongeEventFactory.createSleepingEventFinish(frame.getCurrentCause(), bed, (Player)((Object)this)));
            }
        }
    }
}

