/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.mixin.core.network;

import com.google.common.base.Splitter;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.play.client.CPacketChatMessage;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.message.MessageChannelEvent;
import org.spongepowered.api.event.message.MessageEvent;
import org.spongepowered.api.network.RemoteConnection;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.chat.ChatTypes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.text.SpongeTexts;
import org.spongepowered.server.bridge.network.NetHandlerPlayServerBridge_Vanilla;
import org.spongepowered.server.chat.ChatFormatter;
import org.spongepowered.server.network.VanillaChannelRegistrar;

@Mixin(value={NetHandlerPlayServer.class})
public abstract class NetHandlerPlayServerMixin_Vanilla
implements RemoteConnection,
NetHandlerPlayServerBridge_Vanilla {
    @Shadow
    public EntityPlayerMP field_147369_b;
    private static final Splitter CHANNEL_SPLITTER = Splitter.on('\u0000');
    private final Set<String> vanilla$registeredChannels = new HashSet<String>();

    @Override
    public boolean vanillaBridge$supportsChannel(String name) {
        return this.vanilla$registeredChannels.contains(name);
    }

    @Inject(method={"<init>*"}, at={@At(value="RETURN")})
    private void vanilla$registerChannels(CallbackInfo ci) {
        ((VanillaChannelRegistrar)Sponge.getChannelRegistrar()).registerChannels((NetHandlerPlayServer)this);
    }

    @Inject(method={"processChatMessage"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendMessage(Lnet/minecraft/util/text/ITextComponent;Z)V")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private void vanilla$onProcessChatMessage(CPacketChatMessage packet, CallbackInfo ci, String s, ITextComponent component) {
        ChatFormatter.formatChatComponent((TextComponentTranslation)component);
        Text[] message = SpongeTexts.splitChatMessage((ITextComponent)((TextComponentTranslation)component));
        MessageChannel originalChannel = ((Player)this.field_147369_b).getMessageChannel();
        Sponge.getCauseStackManager().pushCause(this.field_147369_b);
        MessageChannelEvent.Chat event = SpongeEventFactory.createMessageChannelEventChat(Sponge.getCauseStackManager().getCurrentCause(), originalChannel, Optional.of(originalChannel), new MessageEvent.MessageFormatter(message[0], message[1]), Text.of(s), false);
        if (!SpongeImpl.postEvent(event) && !event.isMessageCancelled()) {
            event.getChannel().ifPresent(channel -> channel.send(this.field_147369_b, event.getMessage(), ChatTypes.CHAT));
        } else {
            ci.cancel();
        }
        Sponge.getCauseStackManager().popCause();
    }

    @Redirect(method={"processChatMessage"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/management/PlayerList;sendMessage(Lnet/minecraft/util/text/ITextComponent;Z)V"))
    private void vanilla$cancelSendChatMsgImpl(PlayerList manager, ITextComponent component, boolean chat) {
    }

    @Inject(method={"processCustomPayload"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/PacketThreadUtil;checkThreadAndEnqueue(Lnet/minecraft/network/Packet;Lnet/minecraft/network/INetHandler;Lnet/minecraft/util/IThreadListener;)V", shift=At.Shift.AFTER)}, cancellable=true)
    private void vanilla$onProcessPluginMessage(CPacketCustomPayload packet, CallbackInfo ci) {
        String name = packet.func_149559_c();
        if (name.startsWith("MC|")) {
            return;
        }
        ci.cancel();
        switch (name) {
            case "REGISTER": {
                String channels = packet.func_180760_b().toString(StandardCharsets.UTF_8);
                for (String channel : CHANNEL_SPLITTER.split(channels)) {
                    if (!this.vanilla$registeredChannels.add(channel)) continue;
                    Sponge.getCauseStackManager().pushCause(this);
                    Sponge.getCauseStackManager().pushCause(this.field_147369_b);
                    SpongeImpl.postEvent(SpongeEventFactory.createChannelRegistrationEventRegister(Sponge.getCauseStackManager().getCurrentCause(), channel));
                    Sponge.getCauseStackManager().popCauses(2);
                }
                break;
            }
            case "UNREGISTER": {
                String channels = packet.func_180760_b().toString(StandardCharsets.UTF_8);
                for (String channel : CHANNEL_SPLITTER.split(channels)) {
                    if (!this.vanilla$registeredChannels.remove(channel)) continue;
                    Sponge.getCauseStackManager().pushCause(this);
                    Sponge.getCauseStackManager().pushCause(this.field_147369_b);
                    SpongeImpl.postEvent(SpongeEventFactory.createChannelRegistrationEventUnregister(Sponge.getCauseStackManager().getCurrentCause(), channel));
                    Sponge.getCauseStackManager().popCauses(2);
                }
                break;
            }
            default: {
                ((VanillaChannelRegistrar)Sponge.getChannelRegistrar()).post(this, packet);
            }
        }
    }
}

