/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.mixin.core.server;

import com.google.inject.Inject;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import net.minecraft.crash.CrashReport;
import net.minecraft.network.NetworkSystem;
import net.minecraft.network.Packet;
import net.minecraft.network.ServerStatusResponse;
import net.minecraft.network.play.server.SPacketTimeUpdate;
import net.minecraft.profiler.Profiler;
import net.minecraft.profiler.Snooper;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.ITickable;
import net.minecraft.util.ReportedException;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.WorldServer;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.server.MinecraftServerBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge_AsyncLighting;
import org.spongepowered.common.text.SpongeTexts;
import org.spongepowered.common.world.WorldManager;
import org.spongepowered.server.SpongeVanilla;
import org.spongepowered.server.bridge.ChunkLoaderTickBridge;

@Mixin(value={MinecraftServer.class}, priority=999)
public abstract class MinecraftServerMixin_Vanilla
implements MinecraftServerBridge,
ChunkLoaderTickBridge {
    @Shadow
    @Final
    private static Logger field_147145_h;
    @Shadow
    @Final
    private Snooper field_71307_n;
    @Shadow
    @Final
    private List<ITickable> field_71322_p;
    @Shadow
    @Final
    public Profiler field_71304_b;
    @Shadow
    private PlayerList field_71318_t;
    @Shadow
    private int field_71315_w;
    @Shadow
    @Final
    protected Queue<FutureTask<?>> field_175589_i;
    @Shadow
    public WorldServer[] field_71305_c;
    @Inject
    private static SpongeVanilla vanilla$spongeVanilla;
    private boolean vanilla$skipServerStop = false;
    private final Int2ObjectMap<long[]> vanilla$worldTickTimes = new Int2ObjectOpenHashMap<long[]>(3);

    @Shadow
    public abstract boolean func_71255_r();

    @Shadow
    public abstract NetworkSystem func_147137_ag();

    @Shadow
    public abstract void func_71267_a(boolean var1);

    @Shadow
    public abstract PlayerProfileCache func_152358_ax();

    @Overwrite
    public String getServerModName() {
        return vanilla$spongeVanilla.getName();
    }

    @Overwrite
    public void func_145747_a(ITextComponent component) {
        field_147145_h.info(SpongeTexts.toLegacy(component));
    }

    @org.spongepowered.asm.mixin.injection.Inject(method={"applyServerIconToResponse"}, at={@At(value="HEAD")}, cancellable=true)
    private void vanilla$onAddFaviconToStatusResponse(ServerStatusResponse response, CallbackInfo ci) {
        if (response.func_151316_d() != null) {
            ci.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public void func_71260_j() {
        if (this.vanilla$skipServerStop) {
            return;
        }
        this.vanilla$skipServerStop = true;
        field_147145_h.info("Stopping server");
        vanilla$spongeVanilla.onServerStopping();
        this.func_152358_ax().func_152658_c();
        if (this.func_147137_ag() != null) {
            this.func_147137_ag().func_151268_b();
        }
        if (this.field_71318_t != null) {
            field_147145_h.info("Saving players");
            this.field_71318_t.func_72389_g();
            this.field_71318_t.func_72392_r();
        }
        if (this.field_71305_c != null) {
            field_147145_h.info("Saving worlds");
            for (WorldServer worldserver : this.field_71305_c) {
                if (worldserver == null) continue;
                worldserver.field_73058_d = false;
            }
            this.func_71267_a(false);
            for (WorldServer worldserver1 : this.field_71305_c) {
                if (worldserver1 == null) continue;
                if (SpongeImpl.getGlobalConfigAdapter().getConfig().getModules().useOptimizations() && SpongeImpl.getGlobalConfigAdapter().getConfig().getOptimizations().useAsyncLighting()) {
                    ExecutorService lightingExecutor = ((WorldServerBridge_AsyncLighting)worldserver1).asyncLightingBridge$getLightingExecutor();
                    lightingExecutor.shutdown();
                    try {
                        lightingExecutor.awaitTermination(1L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    finally {
                        lightingExecutor.shutdownNow();
                    }
                }
                WorldManager.unloadWorld(worldserver1, false, true);
                worldserver1.func_73041_k();
            }
            if (this.field_71307_n.func_76468_d()) {
                this.field_71307_n.func_76470_e();
            }
        }
    }

    @org.spongepowered.asm.mixin.injection.Inject(method={"run"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;systemExitNow()V")})
    private void vanilla$callServerStopped(CallbackInfo ci) throws Exception {
        vanilla$spongeVanilla.onServerStopped();
    }

    @Override
    public long[] bridge$getWorldTickTimes(int dimensionId) {
        return (long[])this.vanilla$worldTickTimes.get(dimensionId);
    }

    @Override
    public void bridge$putWorldTickTimes(int dimensionId, long[] tickTimes) {
        this.vanilla$worldTickTimes.put(dimensionId, tickTimes);
    }

    @Override
    public void bridge$removeWorldTickTimes(int dimensionId) {
        this.vanilla$worldTickTimes.remove(dimensionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public void func_71190_q() {
        this.field_71304_b.func_76320_a("jobs");
        Queue<FutureTask<?>> queue = this.field_175589_i;
        synchronized (queue) {
            while (!this.field_175589_i.isEmpty()) {
                Util.func_181617_a(this.field_175589_i.poll(), (Logger)field_147145_h);
            }
        }
        this.field_71304_b.func_76318_c("levels");
        this.chunkIO$tickChunkLoader();
        ObjectIterator<Int2ObjectMap.Entry<WorldServer>> it = WorldManager.worldsIterator();
        while (it.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)it.next();
            WorldServer worldServer = (WorldServer)entry.getValue();
            long i = System.nanoTime();
            if (entry.getIntKey() == 0 || this.func_71255_r()) {
                WorldServerBridge spongeWorld = (WorldServerBridge)worldServer;
                if (spongeWorld.bridge$getChunkGCTickInterval() > 0) {
                    spongeWorld.bridge$doChunkGC();
                }
                this.field_71304_b.func_76320_a(worldServer.func_72912_H().func_76065_j());
                if (this.field_71315_w % 20 == 0) {
                    this.field_71304_b.func_76320_a("timeSync");
                    this.field_71318_t.func_148537_a((Packet)new SPacketTimeUpdate(worldServer.func_82737_E(), worldServer.func_72820_D(), worldServer.func_82736_K().func_82766_b("doDaylightCycle")), ((WorldServerBridge)worldServer).bridge$getDimensionId());
                    this.field_71304_b.func_76319_b();
                }
                this.field_71304_b.func_76320_a("tick");
                try {
                    worldServer.func_72835_b();
                }
                catch (Throwable throwable1) {
                    CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable1, (String)"Exception ticking world");
                    worldServer.func_72914_a(crashreport);
                    throw new ReportedException(crashreport);
                }
                try {
                    worldServer.func_72939_s();
                }
                catch (Throwable throwable) {
                    CrashReport crashreport1 = CrashReport.func_85055_a((Throwable)throwable, (String)"Exception ticking world entities");
                    worldServer.func_72914_a(crashreport1);
                    throw new ReportedException(crashreport1);
                }
                this.field_71304_b.func_76319_b();
                this.field_71304_b.func_76320_a("tracker");
                if (spongeWorld.bridge$getChunkGCTickInterval() > 0) {
                    worldServer.func_72863_F().func_73156_b();
                }
                worldServer.func_73039_n().func_72788_a();
                this.field_71304_b.func_76319_b();
                this.field_71304_b.func_76319_b();
            }
            ((long[])this.vanilla$worldTickTimes.get((int)entry.getIntKey()))[this.field_71315_w % 100] = System.nanoTime() - i;
        }
        this.field_71304_b.func_76318_c("dim_unloading");
        WorldManager.unloadQueuedWorlds();
        this.field_71304_b.func_76318_c("connection");
        this.func_147137_ag().func_151269_c();
        this.field_71304_b.func_76318_c("players");
        this.field_71318_t.func_72374_b();
        this.field_71304_b.func_76318_c("tickables");
        for (int k = 0; k < this.field_71322_p.size(); ++k) {
            this.field_71322_p.get(k).func_73660_a();
        }
        this.field_71304_b.func_76319_b();
    }

    @Override
    public void chunkIO$tickChunkLoader() {
    }
}

