/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.network;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Singleton;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraft.network.play.server.SPacketCustomPayload;
import net.minecraft.server.management.PlayerList;
import org.spongepowered.api.Platform;
import org.spongepowered.api.network.ChannelBinding;
import org.spongepowered.api.network.ChannelRegistrationException;
import org.spongepowered.api.network.RemoteConnection;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.network.SpongeNetworkManager;
import org.spongepowered.server.network.VanillaChannelBinding;
import org.spongepowered.server.network.VanillaIndexedMessageChannel;
import org.spongepowered.server.network.VanillaRawDataChannel;

@Singleton
public class VanillaChannelRegistrar
extends SpongeNetworkManager {
    public static final String INTERNAL_PREFIX = "MC|";
    public static final String REGISTER_CHANNEL = "REGISTER";
    public static final String UNREGISTER_CHANNEL = "UNREGISTER";
    public static final char CHANNEL_SEPARATOR = '\u0000';
    private static final Joiner CHANNEL_JOINER = Joiner.on('\u0000');
    private final Map<String, VanillaChannelBinding> channels = new HashMap<String, VanillaChannelBinding>();

    private static boolean isReservedChannel(String name) {
        return name.startsWith(INTERNAL_PREFIX) || name.equals(REGISTER_CHANNEL) || name.equals(UNREGISTER_CHANNEL);
    }

    private void validateChannel(String name) {
        if (VanillaChannelRegistrar.isReservedChannel(name)) {
            throw new ChannelRegistrationException("Reserved channels cannot be registered by plugins");
        }
        ChannelBinding current = this.channels.get(name);
        if (current != null) {
            throw new ChannelRegistrationException("Channel '" + name + "' is already registered by " + current.getOwner());
        }
    }

    private void registerChannel(VanillaChannelBinding channel) {
        String name = channel.getName();
        this.channels.put(name, channel);
        PlayerList playerList = SpongeImpl.getServer().func_184103_al();
        if (playerList != null) {
            playerList.func_148540_a((Packet)VanillaChannelRegistrar.getRegPacket(name));
        }
    }

    @Override
    public ChannelBinding.IndexedMessageChannel createChannel(Object plugin, String name) throws ChannelRegistrationException {
        PluginContainer container = this.checkCreateChannelArgs(plugin, name);
        this.validateChannel(name);
        VanillaIndexedMessageChannel channel = new VanillaIndexedMessageChannel(this, name, container);
        this.registerChannel(channel);
        return channel;
    }

    @Override
    public ChannelBinding.RawDataChannel createRawChannel(Object plugin, String name) throws ChannelRegistrationException {
        PluginContainer container = this.checkCreateChannelArgs(plugin, name);
        this.validateChannel(name);
        VanillaRawDataChannel channel = new VanillaRawDataChannel(this, name, container);
        this.registerChannel(channel);
        return channel;
    }

    @Override
    public Optional<ChannelBinding> getChannel(String channel) {
        return Optional.ofNullable(this.channels.get(channel));
    }

    @Override
    public void unbindChannel(ChannelBinding channel) {
        String name = channel.getName();
        VanillaChannelBinding binding = this.channels.remove(name);
        Preconditions.checkState(binding != null, "Channel is already unbound");
        binding.invalidate();
        PlayerList playerList = SpongeImpl.getServer().func_184103_al();
        if (playerList != null) {
            playerList.func_148540_a((Packet)VanillaChannelRegistrar.getUnregPacket(name));
        }
    }

    @Override
    public Set<String> getRegisteredChannels(Platform.Type side) {
        if (side == Platform.Type.SERVER) {
            return ImmutableSet.copyOf(this.channels.keySet());
        }
        return ImmutableSet.of();
    }

    @Override
    public boolean isChannelAvailable(String name) {
        return !VanillaChannelRegistrar.isReservedChannel(name) && !this.channels.containsKey(name);
    }

    public void post(RemoteConnection connection, CPacketCustomPayload packet) {
        VanillaChannelBinding binding = this.channels.get(packet.func_149559_c());
        if (binding != null) {
            binding.post(connection, packet.func_180760_b());
        }
    }

    public void registerChannels(NetHandlerPlayServer netHandler) {
        String channels = CHANNEL_JOINER.join(this.channels.keySet());
        PacketBuffer buffer = new PacketBuffer(Unpooled.wrappedBuffer(channels.getBytes(StandardCharsets.UTF_8)));
        netHandler.func_147359_a((Packet)new SPacketCustomPayload(REGISTER_CHANNEL, buffer));
    }
}

