/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.plugin;

import java.util.List;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.util.graph.CyclicGraphException;
import org.spongepowered.common.util.graph.DirectedGraph;
import org.spongepowered.common.util.graph.TopologicalOrder;
import org.spongepowered.server.launch.plugin.PluginCandidate;

final class PluginSorter {
    private PluginSorter() {
    }

    static List<PluginCandidate> sort(Iterable<PluginCandidate> candidates) {
        DirectedGraph<PluginCandidate> graph = new DirectedGraph<PluginCandidate>();
        for (PluginCandidate candidate : candidates) {
            graph.add(candidate);
            for (PluginCandidate pluginCandidate : candidate.getDependencies()) {
                graph.addEdge(candidate, pluginCandidate);
            }
        }
        try {
            return TopologicalOrder.createOrderedLoad(graph);
        }
        catch (CyclicGraphException e) {
            StringBuilder msg = new StringBuilder();
            msg.append("Plugin dependencies are cyclical!\n");
            msg.append("Dependency loops are:\n");
            for (DirectedGraph.DataNode[] dataNodeArray : e.getCycles()) {
                msg.append("[");
                for (DirectedGraph.DataNode node : dataNodeArray) {
                    msg.append(node.getData().toString()).append(" ");
                }
                msg.append("]\n");
            }
            SpongeImpl.getLogger().fatal(msg.toString());
            throw new RuntimeException("Plugin dependencies error.");
        }
    }
}

