/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.server.plugin;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.plugin.PluginManager;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.plugin.meta.PluginMetadata;
import org.spongepowered.server.SpongeVanilla;
import org.spongepowered.server.launch.plugin.PluginCandidate;
import org.spongepowered.server.launch.plugin.PluginSource;
import org.spongepowered.server.launch.plugin.VanillaLaunchPluginManager;
import org.spongepowered.server.plugin.MetadataContainer;
import org.spongepowered.server.plugin.PluginReporter;
import org.spongepowered.server.plugin.PluginSorter;
import org.spongepowered.server.plugin.VanillaPluginContainer;

@Singleton
public class VanillaPluginManager
implements PluginManager {
    private final Injector rootInjector;
    private final Map<String, PluginContainer> plugins = new HashMap<String, PluginContainer>();
    private final Map<Object, PluginContainer> pluginInstances = new IdentityHashMap<Object, PluginContainer>();

    @Inject
    public VanillaPluginManager(Injector injector, SpongeVanilla impl, MetadataContainer metadata) {
        this.rootInjector = injector.getParent();
        this.registerPlugin(SpongeImpl.getMinecraftPlugin());
        this.registerPlugin(SpongeImpl.getSpongePlugin());
        this.registerPlugin(metadata.createContainer("spongeapi", "SpongeAPI", impl.getSource()));
        this.registerPlugin(impl);
        this.registerPlugin(metadata.createContainer("mcp", "Mod Coder Pack", impl.getSource()));
    }

    private void registerPlugin(PluginContainer plugin) {
        this.plugins.put(plugin.getId(), plugin);
        plugin.getInstance().ifPresent(instance -> this.pluginInstances.put(instance, plugin));
    }

    public void loadPlugins() throws IOException {
        Map<String, PluginCandidate> candidateMap = VanillaLaunchPluginManager.getPlugins();
        if (candidateMap.isEmpty()) {
            return;
        }
        try {
            PluginSorter.sort(this.checkRequirements(candidateMap)).forEach(this::loadPlugin);
        }
        catch (Throwable e) {
            throw PluginReporter.crash(e, candidateMap.values());
        }
    }

    private Set<PluginCandidate> checkRequirements(Map<String, PluginCandidate> candidates) {
        HashMap<String, String> loadedPlugins = new HashMap<String, String>();
        for (PluginContainer container : this.plugins.values()) {
            loadedPlugins.put(container.getId(), container.getVersion().orElse(null));
        }
        HashSet<PluginCandidate> successfulCandidates = new HashSet<PluginCandidate>(candidates.size());
        ArrayList<PluginCandidate> failedCandidates = new ArrayList<PluginCandidate>();
        for (PluginCandidate candidate : candidates.values()) {
            if (candidate.collectDependencies(loadedPlugins, candidates)) {
                successfulCandidates.add(candidate);
                continue;
            }
            failedCandidates.add(candidate);
        }
        if (failedCandidates.isEmpty()) {
            return successfulCandidates;
        }
        while (true) {
            boolean updated = false;
            Iterator itr = successfulCandidates.iterator();
            while (itr.hasNext()) {
                PluginCandidate candidate = (PluginCandidate)itr.next();
                if (!candidate.updateRequirements()) continue;
                updated = true;
                itr.remove();
                failedCandidates.add(candidate);
            }
            if (!updated) break;
            failedCandidates.forEach(PluginCandidate::updateRequirements);
        }
        for (PluginCandidate failed : failedCandidates) {
            if (failed.isInvalid()) {
                SpongeImpl.getLogger().error("Plugin '{}' from {} cannot be loaded because it is invalid", (Object)failed.getId(), (Object)failed.getSource());
                continue;
            }
            SpongeImpl.getLogger().error("Cannot load plugin '{}' from {} because it is missing the required dependencies {}", (Object)failed.getId(), (Object)failed.getSource(), (Object)PluginReporter.formatRequirements(failed.getMissingRequirements()));
        }
        return successfulCandidates;
    }

    private void loadPlugin(PluginCandidate candidate) {
        String id = candidate.getId();
        candidate.getSource().addToClasspath();
        PluginMetadata metadata = candidate.getMetadata();
        String name = MoreObjects.firstNonNull(metadata.getName(), id);
        String version = MoreObjects.firstNonNull(metadata.getVersion(), "unknown");
        try {
            Class<?> pluginClass = Class.forName(candidate.getPluginClass());
            Optional<Path> source = candidate.getSource().getPath();
            if (!source.isPresent()) {
                source = PluginSource.find(pluginClass);
            }
            VanillaPluginContainer container = new VanillaPluginContainer(this.rootInjector, pluginClass, metadata, source);
            this.registerPlugin(container);
            Sponge.getEventManager().registerListeners(container, container.getInstance().get());
            SpongeImpl.getLogger().info("Loaded plugin: {} {} (from {})", (Object)name, (Object)version, (Object)candidate.getSource());
        }
        catch (Throwable e) {
            SpongeImpl.getLogger().error("Failed to load plugin: {} {} (from {})", (Object)name, (Object)version, (Object)candidate.getSource(), (Object)e);
        }
    }

    @Override
    public Optional<PluginContainer> fromInstance(Object instance) {
        Preconditions.checkNotNull(instance, "instance");
        if (instance instanceof PluginContainer) {
            return Optional.of((PluginContainer)instance);
        }
        return Optional.ofNullable(this.pluginInstances.get(instance));
    }

    @Override
    public Optional<PluginContainer> getPlugin(String id) {
        return Optional.ofNullable(this.plugins.get(id));
    }

    @Override
    public Collection<PluginContainer> getPlugins() {
        return Collections.unmodifiableCollection(this.plugins.values());
    }

    @Override
    public boolean isLoaded(String id) {
        return this.plugins.containsKey(id);
    }
}

