/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.GrindstoneContainer;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class GrindstoneBlock
extends HorizontalFaceBlock {
    public static final VoxelShape field_220238_a = Block.func_208617_a(2.0, 0.0, 6.0, 4.0, 7.0, 10.0);
    public static final VoxelShape field_220239_b = Block.func_208617_a(12.0, 0.0, 6.0, 14.0, 7.0, 10.0);
    public static final VoxelShape field_220240_c = Block.func_208617_a(2.0, 7.0, 5.0, 4.0, 13.0, 11.0);
    public static final VoxelShape field_220241_d = Block.func_208617_a(12.0, 7.0, 5.0, 14.0, 13.0, 11.0);
    public static final VoxelShape field_220242_e = VoxelShapes.func_197872_a(field_220238_a, field_220240_c);
    public static final VoxelShape field_220243_f = VoxelShapes.func_197872_a(field_220239_b, field_220241_d);
    public static final VoxelShape field_220244_g = VoxelShapes.func_197872_a(field_220242_e, field_220243_f);
    public static final VoxelShape field_220245_h = VoxelShapes.func_197872_a(field_220244_g, Block.func_208617_a(4.0, 4.0, 2.0, 12.0, 16.0, 14.0));
    public static final VoxelShape field_220246_i = Block.func_208617_a(6.0, 0.0, 2.0, 10.0, 7.0, 4.0);
    public static final VoxelShape field_220247_j = Block.func_208617_a(6.0, 0.0, 12.0, 10.0, 7.0, 14.0);
    public static final VoxelShape field_220248_k = Block.func_208617_a(5.0, 7.0, 2.0, 11.0, 13.0, 4.0);
    public static final VoxelShape field_220249_w = Block.func_208617_a(5.0, 7.0, 12.0, 11.0, 13.0, 14.0);
    public static final VoxelShape field_220250_x = VoxelShapes.func_197872_a(field_220246_i, field_220248_k);
    public static final VoxelShape field_220251_y = VoxelShapes.func_197872_a(field_220247_j, field_220249_w);
    public static final VoxelShape field_220252_z = VoxelShapes.func_197872_a(field_220250_x, field_220251_y);
    public static final VoxelShape field_220213_A = VoxelShapes.func_197872_a(field_220252_z, Block.func_208617_a(2.0, 4.0, 4.0, 14.0, 16.0, 12.0));
    public static final VoxelShape field_220214_B = Block.func_208617_a(2.0, 6.0, 0.0, 4.0, 10.0, 7.0);
    public static final VoxelShape field_220215_D = Block.func_208617_a(12.0, 6.0, 0.0, 14.0, 10.0, 7.0);
    public static final VoxelShape field_220216_E = Block.func_208617_a(2.0, 5.0, 7.0, 4.0, 11.0, 13.0);
    public static final VoxelShape field_220217_F = Block.func_208617_a(12.0, 5.0, 7.0, 14.0, 11.0, 13.0);
    public static final VoxelShape field_220218_G = VoxelShapes.func_197872_a(field_220214_B, field_220216_E);
    public static final VoxelShape field_220219_H = VoxelShapes.func_197872_a(field_220215_D, field_220217_F);
    public static final VoxelShape field_220220_I = VoxelShapes.func_197872_a(field_220218_G, field_220219_H);
    public static final VoxelShape field_220221_J = VoxelShapes.func_197872_a(field_220220_I, Block.func_208617_a(4.0, 2.0, 4.0, 12.0, 14.0, 16.0));
    public static final VoxelShape field_220222_K = Block.func_208617_a(2.0, 6.0, 7.0, 4.0, 10.0, 16.0);
    public static final VoxelShape field_220223_L = Block.func_208617_a(12.0, 6.0, 7.0, 14.0, 10.0, 16.0);
    public static final VoxelShape field_220224_M = Block.func_208617_a(2.0, 5.0, 3.0, 4.0, 11.0, 9.0);
    public static final VoxelShape field_220225_N = Block.func_208617_a(12.0, 5.0, 3.0, 14.0, 11.0, 9.0);
    public static final VoxelShape field_220226_O = VoxelShapes.func_197872_a(field_220222_K, field_220224_M);
    public static final VoxelShape field_220227_P = VoxelShapes.func_197872_a(field_220223_L, field_220225_N);
    public static final VoxelShape field_220228_Q = VoxelShapes.func_197872_a(field_220226_O, field_220227_P);
    public static final VoxelShape field_220229_R = VoxelShapes.func_197872_a(field_220228_Q, Block.func_208617_a(4.0, 2.0, 0.0, 12.0, 14.0, 12.0));
    public static final VoxelShape field_220230_S = Block.func_208617_a(7.0, 6.0, 2.0, 16.0, 10.0, 4.0);
    public static final VoxelShape field_220231_T = Block.func_208617_a(7.0, 6.0, 12.0, 16.0, 10.0, 14.0);
    public static final VoxelShape field_220232_U = Block.func_208617_a(3.0, 5.0, 2.0, 9.0, 11.0, 4.0);
    public static final VoxelShape field_220233_V = Block.func_208617_a(3.0, 5.0, 12.0, 9.0, 11.0, 14.0);
    public static final VoxelShape field_220234_W = VoxelShapes.func_197872_a(field_220230_S, field_220232_U);
    public static final VoxelShape field_220235_X = VoxelShapes.func_197872_a(field_220231_T, field_220233_V);
    public static final VoxelShape field_220236_Y = VoxelShapes.func_197872_a(field_220234_W, field_220235_X);
    public static final VoxelShape field_220237_Z = VoxelShapes.func_197872_a(field_220236_Y, Block.func_208617_a(0.0, 2.0, 4.0, 12.0, 14.0, 12.0));
    public static final VoxelShape field_220188_aa = Block.func_208617_a(0.0, 6.0, 2.0, 9.0, 10.0, 4.0);
    public static final VoxelShape field_220189_ab = Block.func_208617_a(0.0, 6.0, 12.0, 9.0, 10.0, 14.0);
    public static final VoxelShape field_220190_ac = Block.func_208617_a(7.0, 5.0, 2.0, 13.0, 11.0, 4.0);
    public static final VoxelShape field_220191_ad = Block.func_208617_a(7.0, 5.0, 12.0, 13.0, 11.0, 14.0);
    public static final VoxelShape field_220192_ae = VoxelShapes.func_197872_a(field_220188_aa, field_220190_ac);
    public static final VoxelShape field_220193_af = VoxelShapes.func_197872_a(field_220189_ab, field_220191_ad);
    public static final VoxelShape field_220194_ag = VoxelShapes.func_197872_a(field_220192_ae, field_220193_af);
    public static final VoxelShape field_220195_ah = VoxelShapes.func_197872_a(field_220194_ag, Block.func_208617_a(4.0, 2.0, 4.0, 16.0, 14.0, 12.0));
    public static final VoxelShape field_220196_ai = Block.func_208617_a(2.0, 9.0, 6.0, 4.0, 16.0, 10.0);
    public static final VoxelShape field_220197_aj = Block.func_208617_a(12.0, 9.0, 6.0, 14.0, 16.0, 10.0);
    public static final VoxelShape field_220198_ak = Block.func_208617_a(2.0, 3.0, 5.0, 4.0, 9.0, 11.0);
    public static final VoxelShape field_220199_al = Block.func_208617_a(12.0, 3.0, 5.0, 14.0, 9.0, 11.0);
    public static final VoxelShape field_220200_am = VoxelShapes.func_197872_a(field_220196_ai, field_220198_ak);
    public static final VoxelShape field_220201_an = VoxelShapes.func_197872_a(field_220197_aj, field_220199_al);
    public static final VoxelShape field_220202_ao = VoxelShapes.func_197872_a(field_220200_am, field_220201_an);
    public static final VoxelShape field_220203_ap = VoxelShapes.func_197872_a(field_220202_ao, Block.func_208617_a(4.0, 0.0, 2.0, 12.0, 12.0, 14.0));
    public static final VoxelShape field_220204_aq = Block.func_208617_a(6.0, 9.0, 2.0, 10.0, 16.0, 4.0);
    public static final VoxelShape field_220205_ar = Block.func_208617_a(6.0, 9.0, 12.0, 10.0, 16.0, 14.0);
    public static final VoxelShape field_220206_as = Block.func_208617_a(5.0, 3.0, 2.0, 11.0, 9.0, 4.0);
    public static final VoxelShape field_220207_at = Block.func_208617_a(5.0, 3.0, 12.0, 11.0, 9.0, 14.0);
    public static final VoxelShape field_220208_au = VoxelShapes.func_197872_a(field_220204_aq, field_220206_as);
    public static final VoxelShape field_220209_av = VoxelShapes.func_197872_a(field_220205_ar, field_220207_at);
    public static final VoxelShape field_220210_aw = VoxelShapes.func_197872_a(field_220208_au, field_220209_av);
    public static final VoxelShape field_220211_ax = VoxelShapes.func_197872_a(field_220210_aw, Block.func_208617_a(2.0, 0.0, 4.0, 14.0, 12.0, 12.0));
    private static final TranslationTextComponent field_220212_az = new TranslationTextComponent("container.grindstone_title", new Object[0]);

    protected GrindstoneBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_185512_D, Direction.NORTH)).func_206870_a(field_196366_M, AttachFace.WALL));
    }

    @Override
    public BlockRenderType func_149645_b(BlockState blockState) {
        return BlockRenderType.MODEL;
    }

    private VoxelShape func_220186_q(BlockState blockState) {
        Direction direction = blockState.func_177229_b(field_185512_D);
        switch ((AttachFace)blockState.func_177229_b(field_196366_M)) {
            case FLOOR: {
                if (direction == Direction.NORTH || direction == Direction.SOUTH) {
                    return field_220245_h;
                }
                return field_220213_A;
            }
            case WALL: {
                if (direction == Direction.NORTH) {
                    return field_220229_R;
                }
                if (direction == Direction.SOUTH) {
                    return field_220221_J;
                }
                if (direction == Direction.EAST) {
                    return field_220195_ah;
                }
                return field_220237_Z;
            }
            case CEILING: {
                if (direction == Direction.NORTH || direction == Direction.SOUTH) {
                    return field_220203_ap;
                }
                return field_220211_ax;
            }
        }
        return field_220213_A;
    }

    @Override
    public VoxelShape func_220071_b(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        return this.func_220186_q(blockState);
    }

    @Override
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        return this.func_220186_q(blockState);
    }

    @Override
    public boolean func_196260_a(BlockState blockState, IWorldReader iWorldReader, BlockPos blockPos) {
        return true;
    }

    @Override
    public boolean func_220051_a(BlockState blockState, World world, BlockPos blockPos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        playerEntity.func_213829_a(blockState.func_215699_b(world, blockPos));
        return true;
    }

    @Override
    public INamedContainerProvider func_220052_b(BlockState blockState, World world, BlockPos blockPos) {
        return new SimpleNamedContainerProvider((n, playerInventory, playerEntity) -> new GrindstoneContainer(n, playerInventory, IWorldPosCallable.func_221488_a(world, blockPos)), field_220212_az);
    }

    @Override
    public BlockState func_185499_a(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.func_206870_a(field_185512_D, rotation.func_185831_a(blockState.func_177229_b(field_185512_D)));
    }

    @Override
    public BlockState func_185471_a(BlockState blockState, Mirror mirror) {
        return blockState.func_185907_a(mirror.func_185800_a(blockState.func_177229_b(field_185512_D)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(field_185512_D, field_196366_M);
    }

    @Override
    public boolean func_196266_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, PathType pathType) {
        return false;
    }
}

