/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk.storage;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.OptionalDynamic;
import com.mojang.datafixers.types.DynamicOps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.util.IDynamicSerializable;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.RegionFileCache;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegionSectionCache<R extends IDynamicSerializable>
extends RegionFileCache {
    private static final Logger field_219120_a = LogManager.getLogger();
    private final Long2ObjectMap<Optional<R>> field_219121_b = new Long2ObjectOpenHashMap();
    private final LongLinkedOpenHashSet field_219122_d = new LongLinkedOpenHashSet();
    private final BiFunction<Runnable, Dynamic<?>, R> field_219123_e;
    private final Function<Runnable, R> field_219124_f;
    private final DataFixer field_219125_g;
    private final DefaultTypeReferences field_219126_h;

    public RegionSectionCache(File file, BiFunction<Runnable, Dynamic<?>, R> biFunction, Function<Runnable, R> function, DataFixer dataFixer, DefaultTypeReferences defaultTypeReferences) {
        super(file);
        this.field_219123_e = biFunction;
        this.field_219124_f = function;
        this.field_219125_g = dataFixer;
        this.field_219126_h = defaultTypeReferences;
    }

    protected void func_219115_a(BooleanSupplier booleanSupplier) {
        while (!this.field_219122_d.isEmpty() && booleanSupplier.getAsBoolean()) {
            ChunkPos chunkPos = SectionPos.func_218170_a(this.field_219122_d.firstLong()).func_218155_u();
            this.func_219117_c(chunkPos);
        }
    }

    @Nullable
    protected Optional<R> func_219106_c(long l) {
        return (Optional)this.field_219121_b.get(l);
    }

    protected Optional<R> func_219113_d(long l) {
        SectionPos sectionPos = SectionPos.func_218170_a(l);
        if (this.func_219114_b(sectionPos)) {
            return Optional.empty();
        }
        Optional<R> \u26032 = this.func_219106_c(l);
        if (\u26032 != null) {
            return \u26032;
        }
        this.func_219107_b(sectionPos.func_218155_u());
        \u26032 = this.func_219106_c(l);
        if (\u26032 == null) {
            throw new IllegalStateException();
        }
        return \u26032;
    }

    protected boolean func_219114_b(SectionPos sectionPos) {
        return World.func_217405_b(SectionPos.func_218142_c(sectionPos.func_218163_b()));
    }

    protected R func_219110_e(long l) {
        Optional<R> optional = this.func_219113_d(l);
        if (optional.isPresent()) {
            return (R)((IDynamicSerializable)optional.get());
        }
        IDynamicSerializable \u26032 = (IDynamicSerializable)this.field_219124_f.apply(() -> this.func_219116_a(l));
        this.field_219121_b.put(l, Optional.of(\u26032));
        return (R)\u26032;
    }

    private void func_219107_b(ChunkPos chunkPos) {
        this.func_219119_a(chunkPos, NBTDynamicOps.field_210820_a, this.func_223138_c(chunkPos));
    }

    @Nullable
    private CompoundNBT func_223138_c(ChunkPos chunkPos) {
        try {
            return this.func_219099_e(chunkPos);
        }
        catch (IOException iOException) {
            field_219120_a.error("Error reading chunk {} data from disk", (Object)chunkPos, (Object)iOException);
            return null;
        }
    }

    private <T> void func_219119_a(ChunkPos chunkPos, DynamicOps<T> dynamicOps2, @Nullable T t) {
        if (t == null) {
            for (int i = 0; i < 16; ++i) {
                this.field_219121_b.put(SectionPos.func_218156_a(chunkPos, i).func_218146_v(), Optional.empty());
            }
        } else {
            DynamicOps<T> dynamicOps2;
            Dynamic \u26032 = new Dynamic(dynamicOps2, t);
            int \u26033 = RegionSectionCache.func_219103_a(\u26032);
            boolean \u26034 = \u26033 != (\u2603 = SharedConstants.func_215069_a().getWorldVersion());
            Dynamic \u26035 = this.field_219125_g.update(this.field_219126_h.func_219816_a(), \u26032, \u26033, \u2603);
            OptionalDynamic \u26036 = \u26035.get("Sections");
            for (int i = 0; i < 16; ++i) {
                long l = SectionPos.func_218156_a(chunkPos, i).func_218146_v();
                Optional<IDynamicSerializable> \u26037 = \u26036.get(Integer.toString(i)).get().map(dynamic -> (IDynamicSerializable)this.field_219123_e.apply(() -> this.func_219116_a(l), (Dynamic<?>)dynamic));
                this.field_219121_b.put(l, \u26037);
                \u26037.ifPresent(iDynamicSerializable -> {
                    this.func_219111_b(l);
                    if (\u26034) {
                        this.func_219116_a(l);
                    }
                });
            }
        }
    }

    private void func_219117_c(ChunkPos chunkPos) {
        Dynamic<INBT> dynamic = this.func_219108_a(chunkPos, NBTDynamicOps.field_210820_a);
        INBT \u26032 = (INBT)dynamic.getValue();
        if (\u26032 instanceof CompoundNBT) {
            try {
                this.func_219100_a(chunkPos, (CompoundNBT)\u26032);
            }
            catch (IOException iOException) {
                field_219120_a.error("Error writing data to disk", (Throwable)iOException);
            }
        } else {
            field_219120_a.error("Expected compound tag, got {}", (Object)\u26032);
        }
    }

    private <T> Dynamic<T> func_219108_a(ChunkPos chunkPos, DynamicOps<T> dynamicOps) {
        HashMap hashMap = Maps.newHashMap();
        for (int i = 0; i < 16; ++i) {
            long l = SectionPos.func_218156_a(chunkPos, i).func_218146_v();
            this.field_219122_d.remove(l);
            Optional \u26032 = (Optional)this.field_219121_b.get(l);
            if (\u26032 == null || !\u26032.isPresent()) continue;
            hashMap.put(dynamicOps.createString(Integer.toString(i)), ((IDynamicSerializable)\u26032.get()).func_218175_a(dynamicOps));
        }
        return new Dynamic(dynamicOps, dynamicOps.createMap((Map)ImmutableMap.of((Object)dynamicOps.createString("Sections"), (Object)dynamicOps.createMap((Map)hashMap), (Object)dynamicOps.createString("DataVersion"), (Object)dynamicOps.createInt(SharedConstants.func_215069_a().getWorldVersion()))));
    }

    protected void func_219111_b(long l) {
    }

    protected void func_219116_a(long l) {
        Optional optional = (Optional)this.field_219121_b.get(l);
        if (optional == null || !optional.isPresent()) {
            field_219120_a.warn("No data for position: {}", (Object)SectionPos.func_218170_a(l));
            return;
        }
        this.field_219122_d.add(l);
    }

    private static int func_219103_a(Dynamic<?> dynamic) {
        return ((Number)dynamic.get("DataVersion").asNumber().orElse(1945)).intValue();
    }

    public void func_219112_a(ChunkPos chunkPos) {
        if (!this.field_219122_d.isEmpty()) {
            for (int i = 0; i < 16; ++i) {
                long l = SectionPos.func_218156_a(chunkPos, i).func_218146_v();
                if (!this.field_219122_d.contains(l)) continue;
                this.func_219117_c(chunkPos);
                return;
            }
        }
    }
}

