/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.IFeatureConfig;

public abstract class HugeTreesFeature<T extends IFeatureConfig>
extends AbstractTreeFeature<T> {
    protected final int field_76522_a;
    protected final BlockState field_76520_b;
    protected final BlockState field_76521_c;
    protected final int field_150538_d;

    public HugeTreesFeature(Function<Dynamic<?>, ? extends T> function, boolean bl, int n, int n2, BlockState blockState, BlockState blockState2) {
        super(function, bl);
        this.field_76522_a = n;
        this.field_150538_d = n2;
        this.field_76520_b = blockState;
        this.field_76521_c = blockState2;
    }

    protected int func_150533_a(Random random) {
        int n = random.nextInt(3) + this.field_76522_a;
        if (this.field_150538_d > 1) {
            n += random.nextInt(this.field_150538_d);
        }
        return n;
    }

    private boolean func_175926_c(IWorldGenerationBaseReader iWorldGenerationBaseReader, BlockPos blockPos, int n) {
        boolean bl = true;
        if (blockPos.func_177956_o() < 1 || blockPos.func_177956_o() + n + 1 > 256) {
            return false;
        }
        for (int i = 0; i <= 1 + n; ++i) {
            \u2603 = 2;
            if (i == 0) {
                \u2603 = 1;
            } else if (i >= 1 + n - 2) {
                \u2603 = 2;
            }
            for (\u2603 = -\u2603; \u2603 <= \u2603 && bl; ++\u2603) {
                for (\u2603 = -\u2603; \u2603 <= \u2603 && bl; ++\u2603) {
                    if (blockPos.func_177956_o() + i >= 0 && blockPos.func_177956_o() + i < 256 && HugeTreesFeature.func_214587_a(iWorldGenerationBaseReader, blockPos.func_177982_a(\u2603, i, \u2603))) continue;
                    bl = false;
                }
            }
        }
        return bl;
    }

    private boolean func_202405_b(IWorldGenerationReader iWorldGenerationReader, BlockPos blockPos) {
        \u2603 = blockPos.func_177977_b();
        if (!HugeTreesFeature.func_214589_h(iWorldGenerationReader, \u2603) || blockPos.func_177956_o() < 2) {
            return false;
        }
        this.func_214584_a(iWorldGenerationReader, \u2603);
        this.func_214584_a(iWorldGenerationReader, \u2603.func_177974_f());
        this.func_214584_a(iWorldGenerationReader, \u2603.func_177968_d());
        this.func_214584_a(iWorldGenerationReader, \u2603.func_177968_d().func_177974_f());
        return true;
    }

    protected boolean func_203427_a(IWorldGenerationReader iWorldGenerationReader, BlockPos blockPos, int n) {
        return this.func_175926_c(iWorldGenerationReader, blockPos, n) && this.func_202405_b(iWorldGenerationReader, blockPos);
    }

    protected void func_222839_a(IWorldGenerationReader iWorldGenerationReader, BlockPos blockPos, int n, MutableBoundingBox mutableBoundingBox, Set<BlockPos> set) {
        int n2 = n * n;
        for (\u2603 = -n; \u2603 <= n + 1; ++\u2603) {
            for (\u2603 = -n; \u2603 <= n + 1; ++\u2603) {
                \u2603 = Math.min(Math.abs(\u2603), Math.abs(\u2603 - 1));
                if (\u2603 + (\u2603 = Math.min(Math.abs(\u2603), Math.abs(\u2603 - 1))) >= 7 || \u2603 * \u2603 + \u2603 * \u2603 > n2 || !HugeTreesFeature.func_214572_g(iWorldGenerationReader, \u2603 = blockPos.func_177982_a(\u2603, 0, \u2603))) continue;
                this.func_208520_a(set, iWorldGenerationReader, \u2603, this.field_76521_c, mutableBoundingBox);
            }
        }
    }

    protected void func_222838_b(IWorldGenerationReader iWorldGenerationReader, BlockPos blockPos, int n, MutableBoundingBox mutableBoundingBox, Set<BlockPos> set) {
        int n2 = n * n;
        for (\u2603 = -n; \u2603 <= n; ++\u2603) {
            for (\u2603 = -n; \u2603 <= n; ++\u2603) {
                if (\u2603 * \u2603 + \u2603 * \u2603 > n2 || !HugeTreesFeature.func_214572_g(iWorldGenerationReader, \u2603 = blockPos.func_177982_a(\u2603, 0, \u2603))) continue;
                this.func_208520_a(set, iWorldGenerationReader, \u2603, this.field_76521_c, mutableBoundingBox);
            }
        }
    }
}

