/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.BasicState;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated
public final class MultiModel
implements IUnbakedModel {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ResourceLocation location;
    @Nullable
    private final IUnbakedModel base;
    private final Map<String, Pair<IUnbakedModel, IModelState>> parts;

    public MultiModel(ResourceLocation location, @Nullable IUnbakedModel base, ImmutableMap<String, Pair<IUnbakedModel, IModelState>> parts) {
        this.location = location;
        this.base = base;
        this.parts = parts;
    }

    public MultiModel(ResourceLocation location, IUnbakedModel base, Map<String, Pair<IUnbakedModel, IModelState>> parts) {
        this(location, base, (ImmutableMap<String, Pair<IUnbakedModel, IModelState>>)ImmutableMap.copyOf(parts));
    }

    public Collection<ResourceLocation> func_187965_e() {
        HashSet deps = Sets.newHashSet();
        if (this.base != null) {
            deps.addAll(this.base.func_187965_e());
        }
        for (Pair<IUnbakedModel, IModelState> pair : this.parts.values()) {
            deps.addAll(((IUnbakedModel)pair.getLeft()).func_187965_e());
        }
        return deps;
    }

    public Collection<ResourceLocation> func_209559_a(Function<ResourceLocation, IUnbakedModel> modelGetter, Set<String> missingTextures) {
        HashSet deps = Sets.newHashSet();
        if (this.base != null) {
            deps.addAll(this.base.func_209559_a(modelGetter, missingTextures));
        }
        for (Pair<IUnbakedModel, IModelState> pair : this.parts.values()) {
            deps.addAll(((IUnbakedModel)pair.getLeft()).func_209559_a(modelGetter, missingTextures));
        }
        return deps;
    }

    @Nullable
    public IBakedModel bake(ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ISprite sprite, VertexFormat format) {
        IBakedModel bakedBase = null;
        if (this.base != null) {
            bakedBase = this.base.bake(bakery, spriteGetter, sprite, format);
        }
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry<String, Pair<IUnbakedModel, IModelState>> entry : this.parts.entrySet()) {
            Pair<IUnbakedModel, IModelState> pair = entry.getValue();
            mapBuilder.put((Object)entry.getKey(), (Object)((IUnbakedModel)pair.getLeft()).bake(bakery, spriteGetter, (ISprite)new ModelStateComposition(sprite.getState(), (IModelState)pair.getRight(), sprite.func_188049_c()), format));
        }
        if (bakedBase == null && this.parts.isEmpty()) {
            LOGGER.error("MultiModel {} is empty (no base model or parts were provided/resolved)", (Object)this.location);
            IUnbakedModel missing = ModelLoaderRegistry.getMissingModel();
            return missing.bake(bakery, spriteGetter, (ISprite)new BasicState(missing.getDefaultState(), sprite.func_188049_c()), format);
        }
        return new Baked(this.location, true, bakedBase, (ImmutableMap<String, IBakedModel>)mapBuilder.build());
    }

    private static final class Baked
    implements IBakedModel {
        private final ResourceLocation location;
        @Nullable
        private final IBakedModel base;
        private final ImmutableMap<String, IBakedModel> parts;
        private final IBakedModel internalBase;
        private final ImmutableMap<ItemCameraTransforms.TransformType, Pair<Baked, TRSRTransformation>> transforms;
        private final ItemOverrideList overrides = new ItemOverrideList(){

            public IBakedModel func_209581_a(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable LivingEntity entity) {
                if (originalModel != this) {
                    return originalModel;
                }
                boolean dirty = false;
                IBakedModel newBase = null;
                if (base != null) {
                    newBase = base.func_188617_f().func_209581_a(base, stack, world, entity);
                    if (base != newBase) {
                        dirty = true;
                    }
                }
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Map.Entry entry : parts.entrySet()) {
                    IBakedModel newPart = ((IBakedModel)entry.getValue()).func_188617_f().func_209581_a((IBakedModel)entry.getValue(), stack, world, entity);
                    builder.put(entry.getKey(), (Object)newPart);
                    if (entry.getValue() == newPart) continue;
                    dirty = true;
                }
                if (dirty) {
                    return new Baked(location, true, newBase, (ImmutableMap<String, IBakedModel>)builder.build());
                }
                return this;
            }
        };

        public Baked(ResourceLocation location, boolean perspective, @Nullable IBakedModel base, ImmutableMap<String, IBakedModel> parts) {
            this.location = location;
            this.base = base;
            this.parts = parts;
            if (base != null) {
                this.internalBase = base;
            } else {
                UnmodifiableIterator iter = parts.values().iterator();
                if (iter.hasNext()) {
                    this.internalBase = (IBakedModel)iter.next();
                } else {
                    throw new IllegalArgumentException("No base model or submodel provided for MultiModel.Baked " + location + ".");
                }
            }
            if (base != null && perspective) {
                EnumMap<ItemCameraTransforms.TransformType, Pair> map = new EnumMap<ItemCameraTransforms.TransformType, Pair>(ItemCameraTransforms.TransformType.class);
                for (ItemCameraTransforms.TransformType type : ItemCameraTransforms.TransformType.values()) {
                    Pair p = base.handlePerspective(type);
                    IBakedModel newBase = (IBakedModel)p.getLeft();
                    Matrix4f matrix = (Matrix4f)p.getRight();
                    if (newBase == base && matrix == null) continue;
                    map.put(type, Pair.of((Object)new Baked(location, false, newBase, parts), (Object)new TRSRTransformation(matrix)));
                }
                this.transforms = ImmutableMap.copyOf(map);
            } else {
                this.transforms = ImmutableMap.of();
            }
        }

        public boolean func_177555_b() {
            return this.internalBase.func_177555_b();
        }

        public boolean isAmbientOcclusion(BlockState state) {
            return this.internalBase.isAmbientOcclusion(state);
        }

        public boolean func_177556_c() {
            return this.internalBase.func_177556_c();
        }

        public boolean func_188618_c() {
            return this.internalBase.func_188618_c();
        }

        public TextureAtlasSprite func_177554_e() {
            return this.internalBase.func_177554_e();
        }

        public ItemCameraTransforms func_177552_f() {
            return this.internalBase.func_177552_f();
        }

        public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
            ImmutableList.Builder quads = ImmutableList.builder();
            if (this.base != null) {
                quads.addAll((Iterable)this.base.func_200117_a(state, side, rand));
            }
            for (IBakedModel bakedPart : this.parts.values()) {
                quads.addAll((Iterable)bakedPart.func_200117_a(state, side, rand));
            }
            return quads.build();
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            Pair p = (Pair)this.transforms.get((Object)cameraTransformType);
            if (p == null) {
                return Pair.of((Object)this, null);
            }
            return Pair.of((Object)p.getLeft(), (Object)((TRSRTransformation)p.getRight()).getMatrixVec());
        }

        public ItemOverrideList func_188617_f() {
            return this.overrides;
        }
    }
}

